/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQFileInfoLabel.h"
#include "MvQFileInfo.h"

static QColor titleCol(50,50,50);
static QColor extraCol(243,71,63);

MvQFileInfoLabel::MvQFileInfoLabel(QWidget* parent) : QLabel(parent)
{
    setObjectName(QString::fromUtf8("fileInfoLabel"));

    //Set size policy
    QSizePolicy sizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);
    sizePolicy.setHeightForWidth(this->sizePolicy().hasHeightForWidth());
    setSizePolicy(sizePolicy);
        //setMinimumSize(QSize(0, 60));
        //setMaximumSize(QSize(16777215, 45));

    setMargin(4);
    setAlignment(Qt::AlignLeft| Qt::AlignVCenter);

    //Other settings
    setAutoFillBackground(true);
    //setFrameShape(QFrame::Box);
        //setFrameShape(QFrame::StyledPanel);
    setTextInteractionFlags(Qt::LinksAccessibleByMouse|Qt::TextSelectableByKeyboard|Qt::TextSelectableByMouse);

}

QString MvQFileInfoLabel::creTitle(QString t)
{
   return "<b><font color=\'" + titleCol.name() + "\'>" + t + ": </font></b>";
}

QString MvQFileInfoLabel::creText(QString t)
{
   return "<font color=\'" + titleCol.name() + "\'>" + t + " </font>";
}

QString MvQFileInfoLabel::creExtraText(QString t)
{
   return "<font color=\'" + extraCol.name() + "\'><b>" + t + "<b> </font>";
}

QString MvQFileInfoLabel::buildTextLabel(QString fileName,QString fileExtraText)
{
    QString s;
    MvQFileInfo info(fileName);

    s=creTitle("File") + creText(info.absoluteFilePath());
    if(!fileExtraText.isEmpty())
    {
       s+=creExtraText(" " + fileExtraText);
    }
    s+="<br>";

    if(info.isSymLink())
    {
        s+=creTitle("Symlink target") + creText(info.symLinkTarget()) + "<br>";
    }

    s+=creTitle("Permissions") + creText(info.formatPermissions());
    s+=creTitle(" Owner") + creText(info.owner());
    s+=creTitle(" Group") + creText(info.group());
    s+=creTitle(" Size") + creText(info.formatSize());
    s+=creTitle(" Modified") + creText(info.formatModDate());

    return s;
}

void MvQFileInfoLabel::setTextLabel(QString fileName)
{
    QString s=buildTextLabel(fileName);
    setText(s);
}

void MvQFileInfoLabel::setGribTextLabel(QString fileName,int messageNum,bool filtered,int filteredMessageNum,bool hasMultiMessage)
{
    QString s=buildTextLabel(fileName);
    s+="<br>";

    if(filtered)
    {
        s+=creTitle("Number of filtered messages") +
           creText(QString::number(filteredMessageNum) +
           " (out of " + QString::number(messageNum) + ")");
    }
    else
    {
        s+=creTitle("Total number of messages") +
           creText(QString::number(messageNum));

        if(hasMultiMessage)
        {
            s+="<font color=#f4a119> (some messages contain multiple fields!) </font>";
        }

    }
    setText(s);
}

void MvQFileInfoLabel::setBufrTextLabel(QString fileName,int messageNum,bool filtered,int filteredMessageNum,bool hasSubset)
{
    //QString s=buildTextLabel(fileName,(filtered)?" filtered!":"");
    QString s=buildTextLabel(fileName);
    s+="<br>";

    if(filtered)
    {
        s+=creTitle("Number of filtered messages") +
           creExtraText(QString::number(filteredMessageNum) +
           " (out of " + QString::number(messageNum) + ")");
    }
    else
    {
        s+=creTitle("Total number of messages") +
           creText(QString::number(messageNum));

        if(hasSubset)
        {
            s+="<font color=#f4a119> (some messages contain subsets!) </font>";
        }

    }
    setText(s);
}

#if 0
void MvQFileInfoLabel::setBufrTextLabel(QString fileName,QString sourceFileName,int messageNum)
{
    QString s;
    if(fileName != sourceFileName && !sourceFileName.isEmpty())
    {
        s=creTitle("Source file") +
          creText(sourceFileName) + "<br>";
        s+=buildTextLabel(fileName,"filtered");
    }
    else
    {
        s=buildTextLabel(fileName);
    }
    s+="<br>";
    s+=creTitle("Total number of messages") +
       creText(QString::number(messageNum));

    setText(s);
}
#endif

void MvQFileInfoLabel::setObstatScatterTextLabel(QString fileName,int itemNum)
{
    QString s=buildTextLabel(fileName);
    s+="<br>";
    s+=creTitle("Total number of items") +
       creText(QString::number(itemNum));

    setText(s);
}

void MvQFileInfoLabel::setOdbTextLabel(QString fileName,QString)
{
    QString s=buildTextLabel(fileName);
    //s+="<br>";
    //s+="<b>Version: </b>";
    //s+=version;

    setText(s);
}

void MvQFileInfoLabel::setGeopTextLabel(QString fileName, QString format, long itemNum)
{
    QString s=buildTextLabel(fileName);
    s+="<br>";
    s+=creTitle("Format") + creText(format) + "<br>" +
    creTitle(" Total number of points") +  creText(QString::number(itemNum));

    setText(s);
}

void MvQFileInfoLabel::setFlextraTextLabel(QString fileName, QString iconName, int itemNum)
{
    QString s;
    s=creTitle("Icon") + creText(iconName) + "<br>" +
      buildTextLabel(fileName) + "<br>" +
      creTitle("Total number of groups") + creText(QString::number(itemNum));

    setText(s);
}

void MvQFileInfoLabel::setProfileTextLabel(QString fileName,int stepNum, int levNum,QString id)
{
    QString s=buildTextLabel(fileName);
    s+="<br>";
    s+=creTitle("Steps") + creText(QString::number(stepNum)) +
       creTitle(" Model levels") + creText(QString::number(levNum)) + "<br>" +
       creTitle("Data type") + creText(id);

    setText(s);
}
