package Config::Model::Dpkg::Compat ;

use 5.10.1;

use Mouse;
extends 'Config::Model::Value';

# extract installed version of debhelper
my $str = `/usr/bin/dpkg -l debhelper`;
my ($version) = ($str =~ /ii\s+debhelper\s+(\d+)/);

if (not $version) {
    die "debhelper package is not installed";
}

sub _fetch_std {
    goto &_fetch_std_no_check;
}

sub _fetch_std_no_check {
    return $version;
}

__PACKAGE__->meta->make_immutable;

1;

=head1 NAME

Config::Model::Dpkg::Compat - Compat model

=head1 SYNOPSIS

 Internal use for Dpkg model

=head1 DESCRIPTION

This class is derived from L<Config::Model::Value>. Its purpose is to
provide a default value for C<Compat> parameter using L<dpkg> call.

=head1 AUTHOR

Dominique Dumont, dod@debian.org

=head1 SEE ALSO

L<Config::Model>,
L<Config::Model::Value>,
