// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/google_ads_field_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [GoogleAdsFieldService.GetGoogleAdsField][google.ads.googleads.v0.services.GoogleAdsFieldService.GetGoogleAdsField].
type GetGoogleAdsFieldRequest struct {
	// The resource name of the field to get.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGoogleAdsFieldRequest) Reset()         { *m = GetGoogleAdsFieldRequest{} }
func (m *GetGoogleAdsFieldRequest) String() string { return proto.CompactTextString(m) }
func (*GetGoogleAdsFieldRequest) ProtoMessage()    {}
func (*GetGoogleAdsFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_field_service_68d4cc408e069062, []int{0}
}
func (m *GetGoogleAdsFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGoogleAdsFieldRequest.Unmarshal(m, b)
}
func (m *GetGoogleAdsFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGoogleAdsFieldRequest.Marshal(b, m, deterministic)
}
func (dst *GetGoogleAdsFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGoogleAdsFieldRequest.Merge(dst, src)
}
func (m *GetGoogleAdsFieldRequest) XXX_Size() int {
	return xxx_messageInfo_GetGoogleAdsFieldRequest.Size(m)
}
func (m *GetGoogleAdsFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGoogleAdsFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGoogleAdsFieldRequest proto.InternalMessageInfo

func (m *GetGoogleAdsFieldRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [GoogleAdsFieldService.SearchGoogleAdsFields][google.ads.googleads.v0.services.GoogleAdsFieldService.SearchGoogleAdsFields].
type SearchGoogleAdsFieldsRequest struct {
	// The query string.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Token of the page to retrieve. If not specified, the first page of
	// results will be returned. Use the value obtained from `next_page_token`
	// in the previous response in order to request the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When too large a page is requested, the server may decide to further
	// limit the number of returned resources.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchGoogleAdsFieldsRequest) Reset()         { *m = SearchGoogleAdsFieldsRequest{} }
func (m *SearchGoogleAdsFieldsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsFieldsRequest) ProtoMessage()    {}
func (*SearchGoogleAdsFieldsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_field_service_68d4cc408e069062, []int{1}
}
func (m *SearchGoogleAdsFieldsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsFieldsRequest.Unmarshal(m, b)
}
func (m *SearchGoogleAdsFieldsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsFieldsRequest.Marshal(b, m, deterministic)
}
func (dst *SearchGoogleAdsFieldsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsFieldsRequest.Merge(dst, src)
}
func (m *SearchGoogleAdsFieldsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsFieldsRequest.Size(m)
}
func (m *SearchGoogleAdsFieldsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsFieldsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsFieldsRequest proto.InternalMessageInfo

func (m *SearchGoogleAdsFieldsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchGoogleAdsFieldsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchGoogleAdsFieldsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for [GoogleAdsFieldService.SearchGoogleAdsFields][google.ads.googleads.v0.services.GoogleAdsFieldService.SearchGoogleAdsFields].
type SearchGoogleAdsFieldsResponse struct {
	// The list of fields that matched the query.
	Results []*resources.GoogleAdsField `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results. Pass the
	// content of this string as the `page_token` attribute of the next request.
	// `next_page_token` is not returned for the last page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of results that match the query ignoring the LIMIT clause.
	TotalResultsCount    int64    `protobuf:"varint,3,opt,name=total_results_count,json=totalResultsCount,proto3" json:"total_results_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchGoogleAdsFieldsResponse) Reset()         { *m = SearchGoogleAdsFieldsResponse{} }
func (m *SearchGoogleAdsFieldsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsFieldsResponse) ProtoMessage()    {}
func (*SearchGoogleAdsFieldsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_field_service_68d4cc408e069062, []int{2}
}
func (m *SearchGoogleAdsFieldsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsFieldsResponse.Unmarshal(m, b)
}
func (m *SearchGoogleAdsFieldsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsFieldsResponse.Marshal(b, m, deterministic)
}
func (dst *SearchGoogleAdsFieldsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsFieldsResponse.Merge(dst, src)
}
func (m *SearchGoogleAdsFieldsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsFieldsResponse.Size(m)
}
func (m *SearchGoogleAdsFieldsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsFieldsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsFieldsResponse proto.InternalMessageInfo

func (m *SearchGoogleAdsFieldsResponse) GetResults() []*resources.GoogleAdsField {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchGoogleAdsFieldsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchGoogleAdsFieldsResponse) GetTotalResultsCount() int64 {
	if m != nil {
		return m.TotalResultsCount
	}
	return 0
}

func init() {
	proto.RegisterType((*GetGoogleAdsFieldRequest)(nil), "google.ads.googleads.v0.services.GetGoogleAdsFieldRequest")
	proto.RegisterType((*SearchGoogleAdsFieldsRequest)(nil), "google.ads.googleads.v0.services.SearchGoogleAdsFieldsRequest")
	proto.RegisterType((*SearchGoogleAdsFieldsResponse)(nil), "google.ads.googleads.v0.services.SearchGoogleAdsFieldsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GoogleAdsFieldServiceClient is the client API for GoogleAdsFieldService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GoogleAdsFieldServiceClient interface {
	// Returns just the requested field.
	GetGoogleAdsField(ctx context.Context, in *GetGoogleAdsFieldRequest, opts ...grpc.CallOption) (*resources.GoogleAdsField, error)
	// Returns all fields that match the search query.
	SearchGoogleAdsFields(ctx context.Context, in *SearchGoogleAdsFieldsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsFieldsResponse, error)
}

type googleAdsFieldServiceClient struct {
	cc *grpc.ClientConn
}

func NewGoogleAdsFieldServiceClient(cc *grpc.ClientConn) GoogleAdsFieldServiceClient {
	return &googleAdsFieldServiceClient{cc}
}

func (c *googleAdsFieldServiceClient) GetGoogleAdsField(ctx context.Context, in *GetGoogleAdsFieldRequest, opts ...grpc.CallOption) (*resources.GoogleAdsField, error) {
	out := new(resources.GoogleAdsField)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.GoogleAdsFieldService/GetGoogleAdsField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *googleAdsFieldServiceClient) SearchGoogleAdsFields(ctx context.Context, in *SearchGoogleAdsFieldsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsFieldsResponse, error) {
	out := new(SearchGoogleAdsFieldsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.GoogleAdsFieldService/SearchGoogleAdsFields", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GoogleAdsFieldServiceServer is the server API for GoogleAdsFieldService service.
type GoogleAdsFieldServiceServer interface {
	// Returns just the requested field.
	GetGoogleAdsField(context.Context, *GetGoogleAdsFieldRequest) (*resources.GoogleAdsField, error)
	// Returns all fields that match the search query.
	SearchGoogleAdsFields(context.Context, *SearchGoogleAdsFieldsRequest) (*SearchGoogleAdsFieldsResponse, error)
}

func RegisterGoogleAdsFieldServiceServer(s *grpc.Server, srv GoogleAdsFieldServiceServer) {
	s.RegisterService(&_GoogleAdsFieldService_serviceDesc, srv)
}

func _GoogleAdsFieldService_GetGoogleAdsField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleAdsFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsFieldServiceServer).GetGoogleAdsField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.GoogleAdsFieldService/GetGoogleAdsField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsFieldServiceServer).GetGoogleAdsField(ctx, req.(*GetGoogleAdsFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GoogleAdsFieldService_SearchGoogleAdsFields_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchGoogleAdsFieldsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsFieldServiceServer).SearchGoogleAdsFields(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.GoogleAdsFieldService/SearchGoogleAdsFields",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsFieldServiceServer).SearchGoogleAdsFields(ctx, req.(*SearchGoogleAdsFieldsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GoogleAdsFieldService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.GoogleAdsFieldService",
	HandlerType: (*GoogleAdsFieldServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGoogleAdsField",
			Handler:    _GoogleAdsFieldService_GetGoogleAdsField_Handler,
		},
		{
			MethodName: "SearchGoogleAdsFields",
			Handler:    _GoogleAdsFieldService_SearchGoogleAdsFields_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/google_ads_field_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/google_ads_field_service.proto", fileDescriptor_google_ads_field_service_68d4cc408e069062)
}

var fileDescriptor_google_ads_field_service_68d4cc408e069062 = []byte{
	// 519 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x8b, 0xd3, 0x4e,
	0x14, 0x66, 0x5a, 0xf6, 0xf7, 0x73, 0x47, 0x17, 0xd9, 0xd1, 0x85, 0x10, 0x77, 0x31, 0x44, 0x57,
	0xcb, 0x82, 0x93, 0xba, 0x5e, 0xa4, 0xa2, 0x25, 0x2b, 0x58, 0x41, 0x90, 0x92, 0xca, 0x1e, 0xa4,
	0x10, 0xc6, 0xe6, 0x19, 0x83, 0xe9, 0x4c, 0x36, 0x33, 0x29, 0xba, 0xe2, 0xc5, 0xbb, 0x27, 0xff,
	0x03, 0x8f, 0xde, 0xfc, 0x0b, 0xbc, 0x78, 0xf2, 0xea, 0xcd, 0xb3, 0x7f, 0x88, 0x4c, 0x92, 0x29,
	0x76, 0xb7, 0xb1, 0xe8, 0x6d, 0xf2, 0xbe, 0xf7, 0x7d, 0xdf, 0x9b, 0xf7, 0xde, 0x04, 0xf7, 0x63,
	0x21, 0xe2, 0x14, 0x3c, 0x16, 0x49, 0xaf, 0x3a, 0xea, 0xd3, 0xac, 0xeb, 0x49, 0xc8, 0x67, 0xc9,
	0x04, 0x4c, 0x34, 0x64, 0x91, 0x0c, 0x9f, 0x27, 0x90, 0x46, 0x61, 0x8d, 0xd0, 0x2c, 0x17, 0x4a,
	0x10, 0xa7, 0xc2, 0x29, 0x8b, 0x24, 0x9d, 0x0b, 0xd0, 0x59, 0x97, 0x1a, 0x01, 0xfb, 0x76, 0x93,
	0x45, 0x0e, 0x52, 0x14, 0xf9, 0x32, 0x8f, 0x4a, 0xdb, 0xde, 0x36, 0xcc, 0x2c, 0xf1, 0x18, 0xe7,
	0x42, 0x31, 0x95, 0x08, 0x2e, 0x2b, 0xd4, 0xed, 0x63, 0x6b, 0x00, 0x6a, 0x50, 0xa6, 0xf8, 0x91,
	0x7c, 0xa0, 0x89, 0x01, 0x1c, 0x15, 0x20, 0x15, 0xb9, 0x82, 0x37, 0x8c, 0x7a, 0xc8, 0xd9, 0x14,
	0x2c, 0xe4, 0xa0, 0xce, 0x7a, 0x70, 0xce, 0x04, 0x1f, 0xb3, 0x29, 0xb8, 0x19, 0xde, 0x1e, 0x01,
	0xcb, 0x27, 0x2f, 0x16, 0x35, 0xa4, 0x11, 0xb9, 0x88, 0xd7, 0x8e, 0x0a, 0xc8, 0x5f, 0xd7, 0xe4,
	0xea, 0x83, 0xec, 0x60, 0x9c, 0xb1, 0x18, 0x42, 0x25, 0x5e, 0x02, 0xb7, 0x5a, 0x25, 0xb4, 0xae,
	0x23, 0x4f, 0x74, 0x80, 0x5c, 0xc2, 0xe5, 0x47, 0x28, 0x93, 0x63, 0xb0, 0xda, 0x0e, 0xea, 0xac,
	0x05, 0x67, 0x74, 0x60, 0x94, 0x1c, 0x83, 0xfb, 0x15, 0xe1, 0x9d, 0x06, 0x4b, 0x99, 0x09, 0x2e,
	0x81, 0x3c, 0xc2, 0xff, 0xe7, 0x20, 0x8b, 0x54, 0x49, 0x0b, 0x39, 0xed, 0xce, 0xd9, 0xfd, 0x9b,
	0xb4, 0xa9, 0xc1, 0xf3, 0xf6, 0xd1, 0x13, 0x3d, 0x30, 0x0a, 0xe4, 0x1a, 0x3e, 0xcf, 0xe1, 0x95,
	0x0a, 0x4f, 0xd5, 0xbb, 0xa1, 0xc3, 0xc3, 0x79, 0xcd, 0x14, 0x5f, 0x50, 0x42, 0xb1, 0x34, 0xac,
	0x89, 0xe1, 0x44, 0x14, 0x5c, 0x95, 0xd5, 0xb7, 0x83, 0xcd, 0x12, 0x0a, 0x2a, 0xe4, 0xbe, 0x06,
	0xf6, 0xdf, 0xb7, 0xf1, 0xd6, 0xa2, 0xe7, 0xa8, 0x1a, 0x36, 0xf9, 0x8c, 0xf0, 0xe6, 0xa9, 0xa1,
	0x90, 0x1e, 0x5d, 0xb5, 0x24, 0xb4, 0x69, 0x92, 0xf6, 0xdf, 0xdf, 0xdf, 0xbd, 0xf1, 0xee, 0xfb,
	0xcf, 0x0f, 0xad, 0xeb, 0x64, 0x57, 0x2f, 0xd9, 0x9b, 0x85, 0x3d, 0xb8, 0x1b, 0x2f, 0xf6, 0xdd,
	0xdb, 0x7b, 0x4b, 0xbe, 0x20, 0xbc, 0xb5, 0x74, 0x28, 0xe4, 0xde, 0xea, 0xba, 0xff, 0xb4, 0x40,
	0x76, 0xff, 0x9f, 0xf9, 0xd5, 0x36, 0xb8, 0xbb, 0xe5, 0x4d, 0x2e, 0xbb, 0xb6, 0xbe, 0xc9, 0x89,
	0xd2, 0x7b, 0xb2, 0xa4, 0xf6, 0xd0, 0xde, 0xc1, 0x0f, 0x84, 0xaf, 0x4e, 0xc4, 0x74, 0xa5, 0xdb,
	0x81, 0xbd, 0x74, 0x6a, 0x43, 0xfd, 0x9c, 0x86, 0xe8, 0xe9, 0xc3, 0x9a, 0x1f, 0x8b, 0x94, 0xf1,
	0x98, 0x8a, 0x3c, 0xf6, 0x62, 0xe0, 0xe5, 0x63, 0x33, 0x0f, 0x37, 0x4b, 0x64, 0xf3, 0xaf, 0xe2,
	0x8e, 0x39, 0x7c, 0x6c, 0xb5, 0x07, 0xbe, 0xff, 0xa9, 0xe5, 0x54, 0x76, 0xd4, 0x8f, 0x7e, 0x9b,
	0x11, 0x3d, 0xec, 0xd2, 0xda, 0x58, 0x7e, 0x33, 0x29, 0x63, 0x3f, 0x92, 0xe3, 0x79, 0xca, 0xf8,
	0xb0, 0x3b, 0x36, 0x29, 0xcf, 0xfe, 0x2b, 0x0b, 0xb8, 0xf5, 0x2b, 0x00, 0x00, 0xff, 0xff, 0xbb,
	0xb6, 0x6e, 0x67, 0xaa, 0x04, 0x00, 0x00,
}
