// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/conversion_action_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [ConversionActionService.GetConversionAction].
type GetConversionActionRequest struct {
	// The resource name of the conversion action to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetConversionActionRequest) Reset()         { *m = GetConversionActionRequest{} }
func (m *GetConversionActionRequest) String() string { return proto.CompactTextString(m) }
func (*GetConversionActionRequest) ProtoMessage()    {}
func (*GetConversionActionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_action_service_1d30046f4e1a0823, []int{0}
}
func (m *GetConversionActionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetConversionActionRequest.Unmarshal(m, b)
}
func (m *GetConversionActionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetConversionActionRequest.Marshal(b, m, deterministic)
}
func (dst *GetConversionActionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetConversionActionRequest.Merge(dst, src)
}
func (m *GetConversionActionRequest) XXX_Size() int {
	return xxx_messageInfo_GetConversionActionRequest.Size(m)
}
func (m *GetConversionActionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetConversionActionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetConversionActionRequest proto.InternalMessageInfo

func (m *GetConversionActionRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [ConversionActionService.MutateConversionActions].
type MutateConversionActionsRequest struct {
	// The ID of the customer whose conversion actions are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual conversion actions.
	Operations           []*ConversionActionOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MutateConversionActionsRequest) Reset()         { *m = MutateConversionActionsRequest{} }
func (m *MutateConversionActionsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateConversionActionsRequest) ProtoMessage()    {}
func (*MutateConversionActionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_action_service_1d30046f4e1a0823, []int{1}
}
func (m *MutateConversionActionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateConversionActionsRequest.Unmarshal(m, b)
}
func (m *MutateConversionActionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateConversionActionsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateConversionActionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateConversionActionsRequest.Merge(dst, src)
}
func (m *MutateConversionActionsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateConversionActionsRequest.Size(m)
}
func (m *MutateConversionActionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateConversionActionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateConversionActionsRequest proto.InternalMessageInfo

func (m *MutateConversionActionsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateConversionActionsRequest) GetOperations() []*ConversionActionOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update, remove) on a conversion action.
type ConversionActionOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*ConversionActionOperation_Create
	//	*ConversionActionOperation_Update
	//	*ConversionActionOperation_Remove
	Operation            isConversionActionOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *ConversionActionOperation) Reset()         { *m = ConversionActionOperation{} }
func (m *ConversionActionOperation) String() string { return proto.CompactTextString(m) }
func (*ConversionActionOperation) ProtoMessage()    {}
func (*ConversionActionOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_action_service_1d30046f4e1a0823, []int{2}
}
func (m *ConversionActionOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConversionActionOperation.Unmarshal(m, b)
}
func (m *ConversionActionOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConversionActionOperation.Marshal(b, m, deterministic)
}
func (dst *ConversionActionOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConversionActionOperation.Merge(dst, src)
}
func (m *ConversionActionOperation) XXX_Size() int {
	return xxx_messageInfo_ConversionActionOperation.Size(m)
}
func (m *ConversionActionOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_ConversionActionOperation.DiscardUnknown(m)
}

var xxx_messageInfo_ConversionActionOperation proto.InternalMessageInfo

func (m *ConversionActionOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isConversionActionOperation_Operation interface {
	isConversionActionOperation_Operation()
}

type ConversionActionOperation_Create struct {
	Create *resources.ConversionAction `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type ConversionActionOperation_Update struct {
	Update *resources.ConversionAction `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type ConversionActionOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*ConversionActionOperation_Create) isConversionActionOperation_Operation() {}

func (*ConversionActionOperation_Update) isConversionActionOperation_Operation() {}

func (*ConversionActionOperation_Remove) isConversionActionOperation_Operation() {}

func (m *ConversionActionOperation) GetOperation() isConversionActionOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *ConversionActionOperation) GetCreate() *resources.ConversionAction {
	if x, ok := m.GetOperation().(*ConversionActionOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *ConversionActionOperation) GetUpdate() *resources.ConversionAction {
	if x, ok := m.GetOperation().(*ConversionActionOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *ConversionActionOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*ConversionActionOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ConversionActionOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ConversionActionOperation_OneofMarshaler, _ConversionActionOperation_OneofUnmarshaler, _ConversionActionOperation_OneofSizer, []interface{}{
		(*ConversionActionOperation_Create)(nil),
		(*ConversionActionOperation_Update)(nil),
		(*ConversionActionOperation_Remove)(nil),
	}
}

func _ConversionActionOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ConversionActionOperation)
	// operation
	switch x := m.Operation.(type) {
	case *ConversionActionOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *ConversionActionOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *ConversionActionOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("ConversionActionOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _ConversionActionOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ConversionActionOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.ConversionAction)
		err := b.DecodeMessage(msg)
		m.Operation = &ConversionActionOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.ConversionAction)
		err := b.DecodeMessage(msg)
		m.Operation = &ConversionActionOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &ConversionActionOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _ConversionActionOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ConversionActionOperation)
	// operation
	switch x := m.Operation.(type) {
	case *ConversionActionOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConversionActionOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConversionActionOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for conversion action mutate.
type MutateConversionActionsResponse struct {
	// All results for the mutate.
	Results              []*MutateConversionActionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateConversionActionsResponse) Reset()         { *m = MutateConversionActionsResponse{} }
func (m *MutateConversionActionsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateConversionActionsResponse) ProtoMessage()    {}
func (*MutateConversionActionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_action_service_1d30046f4e1a0823, []int{3}
}
func (m *MutateConversionActionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateConversionActionsResponse.Unmarshal(m, b)
}
func (m *MutateConversionActionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateConversionActionsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateConversionActionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateConversionActionsResponse.Merge(dst, src)
}
func (m *MutateConversionActionsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateConversionActionsResponse.Size(m)
}
func (m *MutateConversionActionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateConversionActionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateConversionActionsResponse proto.InternalMessageInfo

func (m *MutateConversionActionsResponse) GetResults() []*MutateConversionActionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the conversion action mutate.
type MutateConversionActionResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateConversionActionResult) Reset()         { *m = MutateConversionActionResult{} }
func (m *MutateConversionActionResult) String() string { return proto.CompactTextString(m) }
func (*MutateConversionActionResult) ProtoMessage()    {}
func (*MutateConversionActionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_action_service_1d30046f4e1a0823, []int{4}
}
func (m *MutateConversionActionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateConversionActionResult.Unmarshal(m, b)
}
func (m *MutateConversionActionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateConversionActionResult.Marshal(b, m, deterministic)
}
func (dst *MutateConversionActionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateConversionActionResult.Merge(dst, src)
}
func (m *MutateConversionActionResult) XXX_Size() int {
	return xxx_messageInfo_MutateConversionActionResult.Size(m)
}
func (m *MutateConversionActionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateConversionActionResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateConversionActionResult proto.InternalMessageInfo

func (m *MutateConversionActionResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetConversionActionRequest)(nil), "google.ads.googleads.v0.services.GetConversionActionRequest")
	proto.RegisterType((*MutateConversionActionsRequest)(nil), "google.ads.googleads.v0.services.MutateConversionActionsRequest")
	proto.RegisterType((*ConversionActionOperation)(nil), "google.ads.googleads.v0.services.ConversionActionOperation")
	proto.RegisterType((*MutateConversionActionsResponse)(nil), "google.ads.googleads.v0.services.MutateConversionActionsResponse")
	proto.RegisterType((*MutateConversionActionResult)(nil), "google.ads.googleads.v0.services.MutateConversionActionResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ConversionActionServiceClient is the client API for ConversionActionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversionActionServiceClient interface {
	// Returns the requested conversion action.
	GetConversionAction(ctx context.Context, in *GetConversionActionRequest, opts ...grpc.CallOption) (*resources.ConversionAction, error)
	// Creates, updates or removes conversion actions. Operation statuses are
	// returned.
	MutateConversionActions(ctx context.Context, in *MutateConversionActionsRequest, opts ...grpc.CallOption) (*MutateConversionActionsResponse, error)
}

type conversionActionServiceClient struct {
	cc *grpc.ClientConn
}

func NewConversionActionServiceClient(cc *grpc.ClientConn) ConversionActionServiceClient {
	return &conversionActionServiceClient{cc}
}

func (c *conversionActionServiceClient) GetConversionAction(ctx context.Context, in *GetConversionActionRequest, opts ...grpc.CallOption) (*resources.ConversionAction, error) {
	out := new(resources.ConversionAction)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.ConversionActionService/GetConversionAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversionActionServiceClient) MutateConversionActions(ctx context.Context, in *MutateConversionActionsRequest, opts ...grpc.CallOption) (*MutateConversionActionsResponse, error) {
	out := new(MutateConversionActionsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.ConversionActionService/MutateConversionActions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversionActionServiceServer is the server API for ConversionActionService service.
type ConversionActionServiceServer interface {
	// Returns the requested conversion action.
	GetConversionAction(context.Context, *GetConversionActionRequest) (*resources.ConversionAction, error)
	// Creates, updates or removes conversion actions. Operation statuses are
	// returned.
	MutateConversionActions(context.Context, *MutateConversionActionsRequest) (*MutateConversionActionsResponse, error)
}

func RegisterConversionActionServiceServer(s *grpc.Server, srv ConversionActionServiceServer) {
	s.RegisterService(&_ConversionActionService_serviceDesc, srv)
}

func _ConversionActionService_GetConversionAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionActionServiceServer).GetConversionAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.ConversionActionService/GetConversionAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionActionServiceServer).GetConversionAction(ctx, req.(*GetConversionActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversionActionService_MutateConversionActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateConversionActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionActionServiceServer).MutateConversionActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.ConversionActionService/MutateConversionActions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionActionServiceServer).MutateConversionActions(ctx, req.(*MutateConversionActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversionActionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.ConversionActionService",
	HandlerType: (*ConversionActionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetConversionAction",
			Handler:    _ConversionActionService_GetConversionAction_Handler,
		},
		{
			MethodName: "MutateConversionActions",
			Handler:    _ConversionActionService_MutateConversionActions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/conversion_action_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/conversion_action_service.proto", fileDescriptor_conversion_action_service_1d30046f4e1a0823)
}

var fileDescriptor_conversion_action_service_1d30046f4e1a0823 = []byte{
	// 595 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x94, 0xbf, 0x6f, 0xd3, 0x40,
	0x14, 0xc7, 0xb1, 0x83, 0x82, 0x7a, 0x86, 0xe5, 0x18, 0x6a, 0xac, 0x88, 0x46, 0x86, 0x21, 0xca,
	0x60, 0x47, 0x89, 0x40, 0xa2, 0xa1, 0xa8, 0x4e, 0x25, 0x52, 0x86, 0x40, 0x65, 0xa4, 0x0a, 0x41,
	0xa4, 0xe8, 0x6a, 0x5f, 0x2d, 0xab, 0xb1, 0xcf, 0xdc, 0x9d, 0xb3, 0x44, 0x5d, 0xf8, 0x17, 0x98,
	0x61, 0x60, 0xe4, 0xff, 0xe8, 0xc2, 0xca, 0xca, 0x82, 0xc4, 0x1f, 0x82, 0xce, 0xe7, 0x0b, 0x21,
	0x8d, 0x09, 0x6a, 0x27, 0x3f, 0xfb, 0xbd, 0xfb, 0xbc, 0x1f, 0xdf, 0x7b, 0x06, 0xfb, 0x11, 0x21,
	0xd1, 0x14, 0xbb, 0x28, 0x64, 0xae, 0x34, 0x85, 0x35, 0xeb, 0xb8, 0x0c, 0xd3, 0x59, 0x1c, 0x60,
	0xe6, 0x06, 0x24, 0x9d, 0x61, 0xca, 0x62, 0x92, 0x4e, 0x50, 0xc0, 0xc5, 0xa3, 0x74, 0x39, 0x19,
	0x25, 0x9c, 0xc0, 0xa6, 0x3c, 0xe6, 0xa0, 0x90, 0x39, 0x0b, 0x82, 0x33, 0xeb, 0x38, 0x8a, 0x60,
	0x3d, 0xa9, 0xca, 0x41, 0x31, 0x23, 0x39, 0x5d, 0x9b, 0x44, 0xc2, 0xad, 0x86, 0x3a, 0x9a, 0xc5,
	0x2e, 0x4a, 0x53, 0xc2, 0x91, 0x70, 0xb2, 0xd2, 0x5b, 0xa6, 0x76, 0x8b, 0xb7, 0x93, 0xfc, 0xd4,
	0x3d, 0x8d, 0xf1, 0x34, 0x9c, 0x24, 0x88, 0x9d, 0xc9, 0x08, 0xdb, 0x03, 0xd6, 0x10, 0xf3, 0x83,
	0x05, 0xdd, 0x2b, 0xe0, 0x3e, 0x7e, 0x9f, 0x63, 0xc6, 0xe1, 0x03, 0x70, 0x47, 0x95, 0x30, 0x49,
	0x51, 0x82, 0x4d, 0xad, 0xa9, 0xb5, 0xb6, 0xfc, 0xdb, 0xea, 0xe3, 0x4b, 0x94, 0x60, 0xfb, 0xb3,
	0x06, 0xee, 0x8f, 0x72, 0x8e, 0x38, 0x5e, 0xc5, 0x30, 0xc5, 0xd9, 0x01, 0x46, 0x90, 0x33, 0x4e,
	0x12, 0x4c, 0x27, 0x71, 0x58, 0x52, 0x80, 0xfa, 0xf4, 0x22, 0x84, 0xef, 0x00, 0x20, 0x19, 0xa6,
	0xb2, 0x78, 0x53, 0x6f, 0xd6, 0x5a, 0x46, 0xb7, 0xef, 0x6c, 0x1a, 0x9c, 0xb3, 0x9a, 0xf0, 0x95,
	0x62, 0xf8, 0x4b, 0x38, 0xfb, 0x93, 0x0e, 0xee, 0x55, 0x46, 0xc2, 0x3e, 0x30, 0xf2, 0x2c, 0x44,
	0x1c, 0x17, 0x63, 0x31, 0x6f, 0x36, 0xb5, 0x96, 0xd1, 0xb5, 0x54, 0x6e, 0x35, 0x39, 0xe7, 0xb9,
	0x98, 0xdc, 0x08, 0xb1, 0x33, 0x1f, 0xc8, 0x70, 0x61, 0xc3, 0x11, 0xa8, 0x07, 0x14, 0x23, 0x2e,
	0x27, 0x63, 0x74, 0x7b, 0x95, 0x35, 0x2f, 0xa4, 0xbc, 0x54, 0xf4, 0xe1, 0x0d, 0xbf, 0x84, 0x08,
	0x9c, 0x84, 0x9b, 0xfa, 0xb5, 0x70, 0x12, 0x02, 0x4d, 0x50, 0xa7, 0x38, 0x21, 0x33, 0x6c, 0xd6,
	0xc4, 0xc4, 0x85, 0x47, 0xbe, 0x0f, 0x0c, 0xb0, 0xb5, 0x18, 0x90, 0x3d, 0x07, 0x3b, 0x95, 0xfa,
	0xb1, 0x8c, 0xa4, 0x0c, 0xc3, 0x37, 0xe0, 0x16, 0xc5, 0x2c, 0x9f, 0x72, 0x25, 0xce, 0xb3, 0xcd,
	0xe2, 0xac, 0x67, 0xfa, 0x05, 0xc6, 0x57, 0x38, 0xfb, 0x00, 0x34, 0xfe, 0x15, 0xf8, 0x5f, 0x57,
	0xb0, 0x7b, 0x51, 0x03, 0xdb, 0xab, 0xe7, 0x5f, 0xcb, 0x3a, 0xe0, 0x85, 0x06, 0xee, 0xae, 0xb9,
	0xe2, 0xf0, 0xe9, 0xe6, 0x0e, 0xaa, 0x37, 0xc3, 0xba, 0x8a, 0x32, 0x76, 0xff, 0xc3, 0xf7, 0x5f,
	0x1f, 0xf5, 0x47, 0xb0, 0x27, 0x76, 0x7b, 0xfe, 0x57, 0x5b, 0x7b, 0x6a, 0x19, 0x98, 0xdb, 0x5e,
	0x5a, 0xf6, 0x52, 0x07, 0xb7, 0x7d, 0x0e, 0x7f, 0x6a, 0x60, 0xbb, 0x42, 0x26, 0xb8, 0x7f, 0x55,
	0x35, 0xd4, 0x86, 0x5a, 0xde, 0x35, 0x08, 0xf2, 0x8e, 0xd8, 0x5e, 0xd1, 0x5d, 0xdf, 0x7e, 0x2c,
	0xba, 0xfb, 0xd3, 0xce, 0x7c, 0x69, 0xf3, 0xf7, 0xda, 0xe7, 0x97, 0x9b, 0xdb, 0x4d, 0x0a, 0xf0,
	0xae, 0xd6, 0x1e, 0xfc, 0xd0, 0xc0, 0xc3, 0x80, 0x24, 0x1b, 0x6b, 0x19, 0x34, 0x2a, 0xd4, 0x3e,
	0x12, 0xeb, 0x7a, 0xa4, 0xbd, 0x3d, 0x2c, 0x09, 0x11, 0x99, 0xa2, 0x34, 0x72, 0x08, 0x8d, 0xdc,
	0x08, 0xa7, 0xc5, 0x32, 0xab, 0x3f, 0x6c, 0x16, 0xb3, 0xea, 0x9f, 0x7a, 0x5f, 0x19, 0x5f, 0xf4,
	0xda, 0xd0, 0xf3, 0xbe, 0xea, 0xcd, 0xa1, 0x04, 0x7a, 0x21, 0x73, 0xa4, 0x29, 0xac, 0xe3, 0x8e,
	0x53, 0x26, 0x66, 0xdf, 0x54, 0xc8, 0xd8, 0x0b, 0xd9, 0x78, 0x11, 0x32, 0x3e, 0xee, 0x8c, 0x55,
	0xc8, 0x49, 0xbd, 0x28, 0xa0, 0xf7, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xa6, 0xb4, 0xca, 0x03, 0x54,
	0x06, 0x00, 0x00,
}
