// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/ad_group_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [AdGroupService.GetAdGroup][google.ads.googleads.v0.services.AdGroupService.GetAdGroup].
type GetAdGroupRequest struct {
	// The resource name of the ad group to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupRequest) Reset()         { *m = GetAdGroupRequest{} }
func (m *GetAdGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupRequest) ProtoMessage()    {}
func (*GetAdGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_service_ac847ce94dace47a, []int{0}
}
func (m *GetAdGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupRequest.Unmarshal(m, b)
}
func (m *GetAdGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupRequest.Marshal(b, m, deterministic)
}
func (dst *GetAdGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupRequest.Merge(dst, src)
}
func (m *GetAdGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupRequest.Size(m)
}
func (m *GetAdGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupRequest proto.InternalMessageInfo

func (m *GetAdGroupRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupService.MutateAdGroups][google.ads.googleads.v0.services.AdGroupService.MutateAdGroups].
type MutateAdGroupsRequest struct {
	// The ID of the customer whose ad groups are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual ad groups.
	Operations           []*AdGroupOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *MutateAdGroupsRequest) Reset()         { *m = MutateAdGroupsRequest{} }
func (m *MutateAdGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupsRequest) ProtoMessage()    {}
func (*MutateAdGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_service_ac847ce94dace47a, []int{1}
}
func (m *MutateAdGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupsRequest.Merge(dst, src)
}
func (m *MutateAdGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupsRequest.Size(m)
}
func (m *MutateAdGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupsRequest proto.InternalMessageInfo

func (m *MutateAdGroupsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupsRequest) GetOperations() []*AdGroupOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update, remove) on an ad group.
type AdGroupOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupOperation_Create
	//	*AdGroupOperation_Update
	//	*AdGroupOperation_Remove
	Operation            isAdGroupOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupOperation) Reset()         { *m = AdGroupOperation{} }
func (m *AdGroupOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupOperation) ProtoMessage()    {}
func (*AdGroupOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_service_ac847ce94dace47a, []int{2}
}
func (m *AdGroupOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupOperation.Unmarshal(m, b)
}
func (m *AdGroupOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupOperation.Marshal(b, m, deterministic)
}
func (dst *AdGroupOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupOperation.Merge(dst, src)
}
func (m *AdGroupOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupOperation.Size(m)
}
func (m *AdGroupOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupOperation proto.InternalMessageInfo

func (m *AdGroupOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isAdGroupOperation_Operation interface {
	isAdGroupOperation_Operation()
}

type AdGroupOperation_Create struct {
	Create *resources.AdGroup `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupOperation_Update struct {
	Update *resources.AdGroup `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdGroupOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdGroupOperation_Create) isAdGroupOperation_Operation() {}

func (*AdGroupOperation_Update) isAdGroupOperation_Operation() {}

func (*AdGroupOperation_Remove) isAdGroupOperation_Operation() {}

func (m *AdGroupOperation) GetOperation() isAdGroupOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupOperation) GetCreate() *resources.AdGroup {
	if x, ok := m.GetOperation().(*AdGroupOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupOperation) GetUpdate() *resources.AdGroup {
	if x, ok := m.GetOperation().(*AdGroupOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdGroupOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupOperation_OneofMarshaler, _AdGroupOperation_OneofUnmarshaler, _AdGroupOperation_OneofSizer, []interface{}{
		(*AdGroupOperation_Create)(nil),
		(*AdGroupOperation_Update)(nil),
		(*AdGroupOperation_Remove)(nil),
	}
}

func _AdGroupOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *AdGroupOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *AdGroupOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("AdGroupOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _AdGroupOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroup)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroup)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &AdGroupOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for an ad group mutate.
type MutateAdGroupsResponse struct {
	// All results for the mutate.
	Results              []*MutateAdGroupResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MutateAdGroupsResponse) Reset()         { *m = MutateAdGroupsResponse{} }
func (m *MutateAdGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupsResponse) ProtoMessage()    {}
func (*MutateAdGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_service_ac847ce94dace47a, []int{3}
}
func (m *MutateAdGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupsResponse.Merge(dst, src)
}
func (m *MutateAdGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupsResponse.Size(m)
}
func (m *MutateAdGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupsResponse proto.InternalMessageInfo

func (m *MutateAdGroupsResponse) GetResults() []*MutateAdGroupResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the ad group mutate.
type MutateAdGroupResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupResult) Reset()         { *m = MutateAdGroupResult{} }
func (m *MutateAdGroupResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupResult) ProtoMessage()    {}
func (*MutateAdGroupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_service_ac847ce94dace47a, []int{4}
}
func (m *MutateAdGroupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupResult.Unmarshal(m, b)
}
func (m *MutateAdGroupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupResult.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupResult.Merge(dst, src)
}
func (m *MutateAdGroupResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupResult.Size(m)
}
func (m *MutateAdGroupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupResult proto.InternalMessageInfo

func (m *MutateAdGroupResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupRequest)(nil), "google.ads.googleads.v0.services.GetAdGroupRequest")
	proto.RegisterType((*MutateAdGroupsRequest)(nil), "google.ads.googleads.v0.services.MutateAdGroupsRequest")
	proto.RegisterType((*AdGroupOperation)(nil), "google.ads.googleads.v0.services.AdGroupOperation")
	proto.RegisterType((*MutateAdGroupsResponse)(nil), "google.ads.googleads.v0.services.MutateAdGroupsResponse")
	proto.RegisterType((*MutateAdGroupResult)(nil), "google.ads.googleads.v0.services.MutateAdGroupResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AdGroupServiceClient is the client API for AdGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupServiceClient interface {
	// Returns the requested ad group in full detail.
	GetAdGroup(ctx context.Context, in *GetAdGroupRequest, opts ...grpc.CallOption) (*resources.AdGroup, error)
	// Creates, updates, or removes ad groups. Operation statuses are returned.
	MutateAdGroups(ctx context.Context, in *MutateAdGroupsRequest, opts ...grpc.CallOption) (*MutateAdGroupsResponse, error)
}

type adGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewAdGroupServiceClient(cc *grpc.ClientConn) AdGroupServiceClient {
	return &adGroupServiceClient{cc}
}

func (c *adGroupServiceClient) GetAdGroup(ctx context.Context, in *GetAdGroupRequest, opts ...grpc.CallOption) (*resources.AdGroup, error) {
	out := new(resources.AdGroup)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupService/GetAdGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupServiceClient) MutateAdGroups(ctx context.Context, in *MutateAdGroupsRequest, opts ...grpc.CallOption) (*MutateAdGroupsResponse, error) {
	out := new(MutateAdGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupService/MutateAdGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupServiceServer is the server API for AdGroupService service.
type AdGroupServiceServer interface {
	// Returns the requested ad group in full detail.
	GetAdGroup(context.Context, *GetAdGroupRequest) (*resources.AdGroup, error)
	// Creates, updates, or removes ad groups. Operation statuses are returned.
	MutateAdGroups(context.Context, *MutateAdGroupsRequest) (*MutateAdGroupsResponse, error)
}

func RegisterAdGroupServiceServer(s *grpc.Server, srv AdGroupServiceServer) {
	s.RegisterService(&_AdGroupService_serviceDesc, srv)
}

func _AdGroupService_GetAdGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupServiceServer).GetAdGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupService/GetAdGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupServiceServer).GetAdGroup(ctx, req.(*GetAdGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupService_MutateAdGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupServiceServer).MutateAdGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupService/MutateAdGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupServiceServer).MutateAdGroups(ctx, req.(*MutateAdGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.AdGroupService",
	HandlerType: (*AdGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroup",
			Handler:    _AdGroupService_GetAdGroup_Handler,
		},
		{
			MethodName: "MutateAdGroups",
			Handler:    _AdGroupService_MutateAdGroups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/ad_group_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/ad_group_service.proto", fileDescriptor_ad_group_service_ac847ce94dace47a)
}

var fileDescriptor_ad_group_service_ac847ce94dace47a = []byte{
	// 585 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0xc5, 0x0e, 0x0a, 0xea, 0x18, 0x2a, 0xd8, 0x0a, 0x64, 0x45, 0x48, 0x44, 0x86, 0x43, 0x64,
	0x81, 0x1d, 0xb9, 0x42, 0x8d, 0x52, 0xf5, 0x90, 0x08, 0x91, 0x72, 0x28, 0xad, 0x8c, 0xd4, 0x03,
	0x8a, 0x14, 0x6d, 0xe3, 0xad, 0x65, 0x35, 0xf6, 0x1a, 0xef, 0x3a, 0x97, 0xaa, 0x97, 0x9e, 0xb9,
	0xf1, 0x05, 0x70, 0xe4, 0x1f, 0xf8, 0x01, 0xae, 0xfd, 0x05, 0x3e, 0x81, 0x0f, 0x40, 0xeb, 0xdd,
	0x4d, 0x93, 0x42, 0x14, 0xd2, 0xdb, 0x78, 0x77, 0xde, 0x9b, 0xe7, 0x37, 0x33, 0x0b, 0x3b, 0x31,
	0xa5, 0xf1, 0x84, 0xf8, 0x38, 0x62, 0xbe, 0x0c, 0x45, 0x34, 0x6d, 0xfb, 0x8c, 0x14, 0xd3, 0x64,
	0x4c, 0x98, 0x8f, 0xa3, 0x51, 0x5c, 0xd0, 0x32, 0x1f, 0xa9, 0x13, 0x2f, 0x2f, 0x28, 0xa7, 0xa8,
	0x29, 0xb3, 0x3d, 0x1c, 0x31, 0x6f, 0x06, 0xf4, 0xa6, 0x6d, 0x4f, 0x03, 0x1b, 0xed, 0x65, 0xd4,
	0x05, 0x61, 0xb4, 0x2c, 0xe6, 0xb9, 0x25, 0x67, 0xe3, 0xa9, 0x46, 0xe4, 0x89, 0x8f, 0xb3, 0x8c,
	0x72, 0xcc, 0x13, 0x9a, 0x31, 0x75, 0xab, 0x2a, 0xfa, 0xd5, 0xd7, 0x49, 0x79, 0xea, 0x9f, 0x26,
	0x64, 0x12, 0x8d, 0x52, 0xcc, 0xce, 0x64, 0x86, 0xd3, 0x81, 0x47, 0x03, 0xc2, 0x7b, 0xd1, 0x40,
	0x70, 0x86, 0xe4, 0x53, 0x49, 0x18, 0x47, 0xcf, 0xe1, 0x81, 0x2e, 0x38, 0xca, 0x70, 0x4a, 0x6c,
	0xa3, 0x69, 0xb4, 0x36, 0xc2, 0xfb, 0xfa, 0xf0, 0x3d, 0x4e, 0x89, 0xf3, 0xd9, 0x80, 0xc7, 0x07,
	0x25, 0xc7, 0x9c, 0x28, 0x34, 0xd3, 0xf0, 0x67, 0x60, 0x8d, 0x4b, 0xc6, 0x69, 0x4a, 0x8a, 0x51,
	0x12, 0x29, 0x30, 0xe8, 0xa3, 0x77, 0x11, 0x0a, 0x01, 0x68, 0x4e, 0x0a, 0x29, 0xd5, 0x36, 0x9b,
	0xb5, 0x96, 0x15, 0x04, 0xde, 0x2a, 0x77, 0x3c, 0x55, 0xe7, 0x50, 0x43, 0xc3, 0x39, 0x16, 0xe7,
	0xd2, 0x84, 0x87, 0x37, 0x13, 0xd0, 0x2e, 0x58, 0x65, 0x1e, 0x61, 0x4e, 0xaa, 0x5f, 0xb6, 0xef,
	0x36, 0x8d, 0x96, 0x15, 0x34, 0x74, 0x25, 0xed, 0x8a, 0xf7, 0x56, 0xb8, 0x72, 0x80, 0xd9, 0x59,
	0x08, 0x32, 0x5d, 0xc4, 0xe8, 0x0d, 0xd4, 0xc7, 0x05, 0xc1, 0x5c, 0xfe, 0xbe, 0x15, 0xb8, 0x4b,
	0x15, 0xce, 0xba, 0xa3, 0x25, 0xee, 0xdf, 0x09, 0x15, 0x56, 0xb0, 0x48, 0x4e, 0xdb, 0xbc, 0x0d,
	0x8b, 0xc4, 0x22, 0x1b, 0xea, 0x05, 0x49, 0xe9, 0x94, 0xd8, 0x35, 0xe1, 0xa6, 0xb8, 0x91, 0xdf,
	0x7d, 0x0b, 0x36, 0x66, 0x2e, 0x38, 0x09, 0x3c, 0xb9, 0xd9, 0x12, 0x96, 0xd3, 0x8c, 0x11, 0x74,
	0x08, 0xf7, 0x0a, 0xc2, 0xca, 0x09, 0xd7, 0x7e, 0xbf, 0x5e, 0xed, 0xf7, 0x02, 0x55, 0x58, 0xa1,
	0x43, 0xcd, 0xe2, 0x74, 0x61, 0xeb, 0x1f, 0xf7, 0xff, 0x35, 0x3a, 0xc1, 0x6f, 0x13, 0x36, 0x15,
	0xec, 0x83, 0x2c, 0x86, 0xbe, 0x1a, 0x00, 0xd7, 0x83, 0x88, 0xb6, 0x57, 0xab, 0xfb, 0x6b, 0x6c,
	0x1b, 0x6b, 0x58, 0xeb, 0x04, 0x97, 0x57, 0xbf, 0xbe, 0x98, 0x2f, 0x91, 0x2b, 0xb6, 0xeb, 0x7c,
	0x41, 0xf2, 0x9e, 0x9e, 0x54, 0xe6, 0xbb, 0x3e, 0x56, 0x46, 0xfa, 0xee, 0x05, 0xfa, 0x61, 0xc0,
	0xe6, 0xa2, 0xbd, 0x68, 0x67, 0x4d, 0x17, 0xf5, 0x8e, 0x34, 0x3a, 0xeb, 0x03, 0x65, 0x27, 0x9d,
	0x4e, 0xa5, 0x3c, 0x70, 0x5e, 0x09, 0xe5, 0xd7, 0x52, 0xcf, 0xe7, 0x56, 0x6e, 0xcf, 0xbd, 0x98,
	0x09, 0xef, 0xa6, 0x15, 0x4d, 0xd7, 0x70, 0xfb, 0x57, 0x06, 0xbc, 0x18, 0xd3, 0x74, 0x65, 0xe5,
	0xfe, 0xd6, 0x62, 0x73, 0x8e, 0xc4, 0x9e, 0x1c, 0x19, 0x1f, 0xf7, 0x15, 0x30, 0xa6, 0x13, 0x9c,
	0xc5, 0x1e, 0x2d, 0x62, 0x3f, 0x26, 0x59, 0xb5, 0x45, 0xfa, 0xb5, 0xca, 0x13, 0xb6, 0xfc, 0x5d,
	0xdc, 0xd5, 0xc1, 0x37, 0xb3, 0x36, 0xe8, 0xf5, 0xbe, 0x9b, 0xcd, 0x81, 0x24, 0xec, 0x45, 0xcc,
	0x93, 0xa1, 0x88, 0x8e, 0xdb, 0x9e, 0x2a, 0xcc, 0x7e, 0xea, 0x94, 0x61, 0x2f, 0x62, 0xc3, 0x59,
	0xca, 0xf0, 0xb8, 0x3d, 0xd4, 0x29, 0x27, 0xf5, 0x4a, 0xc0, 0xf6, 0x9f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x08, 0x37, 0xc8, 0x48, 0x97, 0x05, 0x00, 0x00,
}
