// Code generated by "./generator ./com.deepin.daemon.accounts"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package accounts

import (
	"fmt"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
	"github.com/stretchr/testify/mock"
)

type MockAccounts struct {
	MockInterfaceAccounts // interface com.deepin.daemon.Accounts
	proxy.MockObject
}

type MockInterfaceAccounts struct {
	mock.Mock
}

// method AllowGuestAccount

func (v *MockInterfaceAccounts) GoAllowGuestAccount(flags dbus.Flags, ch chan *dbus.Call, allow bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, allow)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) AllowGuestAccount(flags dbus.Flags, allow bool) error {
	mockArgs := v.Called(flags, allow)

	return mockArgs.Error(0)
}

// method CreateGuestAccount

func (v *MockInterfaceAccounts) GoCreateGuestAccount(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) CreateGuestAccount(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method CreateUser

func (v *MockInterfaceAccounts) GoCreateUser(flags dbus.Flags, ch chan *dbus.Call, name string, fullName string, type0 int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, name, fullName, type0)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) CreateUser(flags dbus.Flags, name string, fullName string, type0 int32) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, name, fullName, type0)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method DeleteUser

func (v *MockInterfaceAccounts) GoDeleteUser(flags dbus.Flags, ch chan *dbus.Call, name string, rmFiles bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, name, rmFiles)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) DeleteUser(flags dbus.Flags, name string, rmFiles bool) error {
	mockArgs := v.Called(flags, name, rmFiles)

	return mockArgs.Error(0)
}

// method FindUserById

func (v *MockInterfaceAccounts) GoFindUserById(flags dbus.Flags, ch chan *dbus.Call, uid string) *dbus.Call {
	mockArgs := v.Called(flags, ch, uid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) FindUserById(flags dbus.Flags, uid string) (string, error) {
	mockArgs := v.Called(flags, uid)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method FindUserByName

func (v *MockInterfaceAccounts) GoFindUserByName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	mockArgs := v.Called(flags, ch, name)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) FindUserByName(flags dbus.Flags, name string) (string, error) {
	mockArgs := v.Called(flags, name)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method IsPasswordValid

func (v *MockInterfaceAccounts) GoIsPasswordValid(flags dbus.Flags, ch chan *dbus.Call, password string) *dbus.Call {
	mockArgs := v.Called(flags, ch, password)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) IsPasswordValid(flags dbus.Flags, password string) (bool, string, int32, error) {
	mockArgs := v.Called(flags, password)

	ret2, ok := mockArgs.Get(2).(int32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 2, mockArgs.Get(2)))
	}

	return mockArgs.Bool(0), mockArgs.String(1), ret2, mockArgs.Error(3)
}

// method IsUsernameValid

func (v *MockInterfaceAccounts) GoIsUsernameValid(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	mockArgs := v.Called(flags, ch, name)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) IsUsernameValid(flags dbus.Flags, name string) (bool, string, int32, error) {
	mockArgs := v.Called(flags, name)

	ret2, ok := mockArgs.Get(2).(int32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 2, mockArgs.Get(2)))
	}

	return mockArgs.Bool(0), mockArgs.String(1), ret2, mockArgs.Error(3)
}

// method RandUserIcon

func (v *MockInterfaceAccounts) GoRandUserIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAccounts) RandUserIcon(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// signal UserAdded

func (v *MockInterfaceAccounts) ConnectUserAdded(cb func(objPath string)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal UserDeleted

func (v *MockInterfaceAccounts) ConnectUserDeleted(cb func(objPath string)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property UserList as

func (v *MockInterfaceAccounts) UserList() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property GuestIcon s

func (v *MockInterfaceAccounts) GuestIcon() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property AllowGuest b

func (v *MockInterfaceAccounts) AllowGuest() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockUser struct {
	MockInterfaceUser // interface com.deepin.daemon.Accounts.User
	proxy.MockObject
}

type MockInterfaceUser struct {
	mock.Mock
}

// method AddGroup

func (v *MockInterfaceUser) GoAddGroup(flags dbus.Flags, ch chan *dbus.Call, group string) *dbus.Call {
	mockArgs := v.Called(flags, ch, group)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) AddGroup(flags dbus.Flags, group string) error {
	mockArgs := v.Called(flags, group)

	return mockArgs.Error(0)
}

// method DeleteGroup

func (v *MockInterfaceUser) GoDeleteGroup(flags dbus.Flags, ch chan *dbus.Call, group string) *dbus.Call {
	mockArgs := v.Called(flags, ch, group)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) DeleteGroup(flags dbus.Flags, group string) error {
	mockArgs := v.Called(flags, group)

	return mockArgs.Error(0)
}

// method DeleteIconFile

func (v *MockInterfaceUser) GoDeleteIconFile(flags dbus.Flags, ch chan *dbus.Call, icon string) *dbus.Call {
	mockArgs := v.Called(flags, ch, icon)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) DeleteIconFile(flags dbus.Flags, icon string) error {
	mockArgs := v.Called(flags, icon)

	return mockArgs.Error(0)
}

// method EnableNoPasswdLogin

func (v *MockInterfaceUser) GoEnableNoPasswdLogin(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, enabled)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) EnableNoPasswdLogin(flags dbus.Flags, enabled bool) error {
	mockArgs := v.Called(flags, enabled)

	return mockArgs.Error(0)
}

// method GetReminderInfo

func (v *MockInterfaceUser) GoGetReminderInfo(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) GetReminderInfo(flags dbus.Flags) (LoginReminderInfo, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).(LoginReminderInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method IsPasswordExpired

func (v *MockInterfaceUser) GoIsPasswordExpired(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) IsPasswordExpired(flags dbus.Flags) (bool, error) {
	mockArgs := v.Called(flags)

	return mockArgs.Bool(0), mockArgs.Error(1)
}

// method PasswordExpiredInfo

func (v *MockInterfaceUser) GoPasswordExpiredInfo(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) PasswordExpiredInfo(flags dbus.Flags) (int32, int64, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).(int32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	ret1, ok := mockArgs.Get(1).(int64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 1, mockArgs.Get(1)))
	}

	return ret0, ret1, mockArgs.Error(2)
}

// method SetAutomaticLogin

func (v *MockInterfaceUser) GoSetAutomaticLogin(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, enabled)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetAutomaticLogin(flags dbus.Flags, enabled bool) error {
	mockArgs := v.Called(flags, enabled)

	return mockArgs.Error(0)
}

// method SetCurrentWorkspace

func (v *MockInterfaceUser) GoSetCurrentWorkspace(flags dbus.Flags, ch chan *dbus.Call, currentWorkspace int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, currentWorkspace)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetCurrentWorkspace(flags dbus.Flags, currentWorkspace int32) error {
	mockArgs := v.Called(flags, currentWorkspace)

	return mockArgs.Error(0)
}

// method SetDesktopBackgrounds

func (v *MockInterfaceUser) GoSetDesktopBackgrounds(flags dbus.Flags, ch chan *dbus.Call, val []string) *dbus.Call {
	mockArgs := v.Called(flags, ch, val)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetDesktopBackgrounds(flags dbus.Flags, val []string) error {
	mockArgs := v.Called(flags, val)

	return mockArgs.Error(0)
}

// method SetFullName

func (v *MockInterfaceUser) GoSetFullName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	mockArgs := v.Called(flags, ch, name)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetFullName(flags dbus.Flags, name string) error {
	mockArgs := v.Called(flags, name)

	return mockArgs.Error(0)
}

// method SetGreeterBackground

func (v *MockInterfaceUser) GoSetGreeterBackground(flags dbus.Flags, ch chan *dbus.Call, bg string) *dbus.Call {
	mockArgs := v.Called(flags, ch, bg)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetGreeterBackground(flags dbus.Flags, bg string) error {
	mockArgs := v.Called(flags, bg)

	return mockArgs.Error(0)
}

// method SetGroups

func (v *MockInterfaceUser) GoSetGroups(flags dbus.Flags, ch chan *dbus.Call, groups []string) *dbus.Call {
	mockArgs := v.Called(flags, ch, groups)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetGroups(flags dbus.Flags, groups []string) error {
	mockArgs := v.Called(flags, groups)

	return mockArgs.Error(0)
}

// method SetHistoryLayout

func (v *MockInterfaceUser) GoSetHistoryLayout(flags dbus.Flags, ch chan *dbus.Call, list []string) *dbus.Call {
	mockArgs := v.Called(flags, ch, list)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetHistoryLayout(flags dbus.Flags, list []string) error {
	mockArgs := v.Called(flags, list)

	return mockArgs.Error(0)
}

// method SetHomeDir

func (v *MockInterfaceUser) GoSetHomeDir(flags dbus.Flags, ch chan *dbus.Call, home string) *dbus.Call {
	mockArgs := v.Called(flags, ch, home)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetHomeDir(flags dbus.Flags, home string) error {
	mockArgs := v.Called(flags, home)

	return mockArgs.Error(0)
}

// method SetIconFile

func (v *MockInterfaceUser) GoSetIconFile(flags dbus.Flags, ch chan *dbus.Call, iconURI string) *dbus.Call {
	mockArgs := v.Called(flags, ch, iconURI)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetIconFile(flags dbus.Flags, iconURI string) error {
	mockArgs := v.Called(flags, iconURI)

	return mockArgs.Error(0)
}

// method SetLayout

func (v *MockInterfaceUser) GoSetLayout(flags dbus.Flags, ch chan *dbus.Call, layout string) *dbus.Call {
	mockArgs := v.Called(flags, ch, layout)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetLayout(flags dbus.Flags, layout string) error {
	mockArgs := v.Called(flags, layout)

	return mockArgs.Error(0)
}

// method SetLocale

func (v *MockInterfaceUser) GoSetLocale(flags dbus.Flags, ch chan *dbus.Call, locale string) *dbus.Call {
	mockArgs := v.Called(flags, ch, locale)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetLocale(flags dbus.Flags, locale string) error {
	mockArgs := v.Called(flags, locale)

	return mockArgs.Error(0)
}

// method SetLocked

func (v *MockInterfaceUser) GoSetLocked(flags dbus.Flags, ch chan *dbus.Call, locked bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, locked)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetLocked(flags dbus.Flags, locked bool) error {
	mockArgs := v.Called(flags, locked)

	return mockArgs.Error(0)
}

// method SetLongDateFormat

func (v *MockInterfaceUser) GoSetLongDateFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetLongDateFormat(flags dbus.Flags, value int32) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// method SetLongTimeFormat

func (v *MockInterfaceUser) GoSetLongTimeFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetLongTimeFormat(flags dbus.Flags, value int32) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// method SetMaxPasswordAge

func (v *MockInterfaceUser) GoSetMaxPasswordAge(flags dbus.Flags, ch chan *dbus.Call, nDays int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, nDays)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetMaxPasswordAge(flags dbus.Flags, nDays int32) error {
	mockArgs := v.Called(flags, nDays)

	return mockArgs.Error(0)
}

// method SetPassword

func (v *MockInterfaceUser) GoSetPassword(flags dbus.Flags, ch chan *dbus.Call, password string) *dbus.Call {
	mockArgs := v.Called(flags, ch, password)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetPassword(flags dbus.Flags, password string) error {
	mockArgs := v.Called(flags, password)

	return mockArgs.Error(0)
}

// method SetShell

func (v *MockInterfaceUser) GoSetShell(flags dbus.Flags, ch chan *dbus.Call, shell string) *dbus.Call {
	mockArgs := v.Called(flags, ch, shell)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetShell(flags dbus.Flags, shell string) error {
	mockArgs := v.Called(flags, shell)

	return mockArgs.Error(0)
}

// method SetShortDateFormat

func (v *MockInterfaceUser) GoSetShortDateFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetShortDateFormat(flags dbus.Flags, value int32) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// method SetShortTimeFormat

func (v *MockInterfaceUser) GoSetShortTimeFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetShortTimeFormat(flags dbus.Flags, value int32) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// method SetUse24HourFormat

func (v *MockInterfaceUser) GoSetUse24HourFormat(flags dbus.Flags, ch chan *dbus.Call, value bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetUse24HourFormat(flags dbus.Flags, value bool) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// method SetWeekBegins

func (v *MockInterfaceUser) GoSetWeekBegins(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetWeekBegins(flags dbus.Flags, value int32) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// method SetWeekdayFormat

func (v *MockInterfaceUser) GoSetWeekdayFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, value)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) SetWeekdayFormat(flags dbus.Flags, value int32) error {
	mockArgs := v.Called(flags, value)

	return mockArgs.Error(0)
}

// property ShortDateFormat i

func (v *MockInterfaceUser) ShortDateFormat() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property DesktopBackgrounds as

func (v *MockInterfaceUser) DesktopBackgrounds() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Groups as

func (v *MockInterfaceUser) Groups() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property GreeterBackground s

func (v *MockInterfaceUser) GreeterBackground() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HistoryLayout as

func (v *MockInterfaceUser) HistoryLayout() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UserName s

func (v *MockInterfaceUser) UserName() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property FullName s

func (v *MockInterfaceUser) FullName() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Use24HourFormat b

func (v *MockInterfaceUser) Use24HourFormat() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UUID s

func (v *MockInterfaceUser) UUID() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IconFile s

func (v *MockInterfaceUser) IconFile() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property LongDateFormat i

func (v *MockInterfaceUser) LongDateFormat() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PasswordLastChange i

func (v *MockInterfaceUser) PasswordLastChange() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property LoginTime t

func (v *MockInterfaceUser) LoginTime() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Gid s

func (v *MockInterfaceUser) Gid() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PasswordStatus s

func (v *MockInterfaceUser) PasswordStatus() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property MaxPasswordAge i

func (v *MockInterfaceUser) MaxPasswordAge() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property AutomaticLogin b

func (v *MockInterfaceUser) AutomaticLogin() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Workspace i

func (v *MockInterfaceUser) Workspace() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property NoPasswdLogin b

func (v *MockInterfaceUser) NoPasswdLogin() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Shell s

func (v *MockInterfaceUser) Shell() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property ShortTimeFormat i

func (v *MockInterfaceUser) ShortTimeFormat() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property LongTimeFormat i

func (v *MockInterfaceUser) LongTimeFormat() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Layout s

func (v *MockInterfaceUser) Layout() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property WeekdayFormat i

func (v *MockInterfaceUser) WeekdayFormat() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property CreatedTime t

func (v *MockInterfaceUser) CreatedTime() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property XSession s

func (v *MockInterfaceUser) XSession() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Locked b

func (v *MockInterfaceUser) Locked() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HomeDir s

func (v *MockInterfaceUser) HomeDir() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Locale s

func (v *MockInterfaceUser) Locale() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property WeekBegins i

func (v *MockInterfaceUser) WeekBegins() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IconList as

func (v *MockInterfaceUser) IconList() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Uid s

func (v *MockInterfaceUser) Uid() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SystemAccount b

func (v *MockInterfaceUser) SystemAccount() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property AccountType i

func (v *MockInterfaceUser) AccountType() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockImageBlur struct {
	MockInterfaceImageBlur // interface com.deepin.daemon.ImageBlur
	proxy.MockObject
}

type MockInterfaceImageBlur struct {
	mock.Mock
}

// method Delete

func (v *MockInterfaceImageBlur) GoDelete(flags dbus.Flags, ch chan *dbus.Call, file string) *dbus.Call {
	mockArgs := v.Called(flags, ch, file)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceImageBlur) Delete(flags dbus.Flags, file string) error {
	mockArgs := v.Called(flags, file)

	return mockArgs.Error(0)
}

// method Get

func (v *MockInterfaceImageBlur) GoGet(flags dbus.Flags, ch chan *dbus.Call, source string) *dbus.Call {
	mockArgs := v.Called(flags, ch, source)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceImageBlur) Get(flags dbus.Flags, source string) (string, error) {
	mockArgs := v.Called(flags, source)

	return mockArgs.String(0), mockArgs.Error(1)
}

// signal BlurDone

func (v *MockInterfaceImageBlur) ConnectBlurDone(cb func(imgFile string, imgBlurFile string, ok bool)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}
