/* worm.c generated by valac 0.40.8, the Vala compiler
 * generated from worm.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>


#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;
enum  {
	WORM_0_PROPERTY,
	WORM_STARTING_POSITION_PROPERTY,
	WORM_ID_PROPERTY,
	WORM_IS_MATERIALIZED_PROPERTY,
	WORM_LIVES_PROPERTY,
	WORM_SCORE_PROPERTY,
	WORM_LENGTH_PROPERTY,
	WORM_HEAD_PROPERTY,
	WORM_LIST_PROPERTY,
	WORM_NUM_PROPERTIES
};
static GParamSpec* worm_properties[WORM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
enum  {
	WORM_ADDED_SIGNAL,
	WORM_FINISH_ADDED_SIGNAL,
	WORM_MOVED_SIGNAL,
	WORM_RESCALED_SIGNAL,
	WORM_DIED_SIGNAL,
	WORM_TAIL_REDUCED_SIGNAL,
	WORM_REVERSED_SIGNAL,
	WORM_BONUS_FOUND_SIGNAL,
	WORM_WARP_FOUND_SIGNAL,
	WORM_NUM_SIGNALS
};
static guint worm_signals[WORM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _WormPrivate {
	Position _starting_position;
	gint _id;
	gboolean _is_materialized;
	gint rounds_dematerialized;
	gint _lives;
	gint _score;
	GeeArrayQueue* key_queue;
	GeeLinkedList* _list;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;


static gpointer worm_parent_class = NULL;
static guint* worm_deadend_board;
static gint worm_deadend_board_length1;
static gint worm_deadend_board_length2;
static guint* worm_deadend_board = NULL;
static gint worm_deadend_board_length1 = 0;
static gint worm_deadend_board_length2 = 0;
static guint worm_deadend_runnumber;
static guint worm_deadend_runnumber = (guint) 0;

GType worm_direction_get_type (void) G_GNUC_CONST;
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GType worm_get_type (void) G_GNUC_CONST;
#define WORM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WORM, WormPrivate))
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define WORM_STARTING_LENGTH 5
#define WORM_STARTING_LIVES 6
#define WORM_MAX_LIVES 12
#define WORM_GROW_FACTOR 4
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type,
                      gint id);
static void worm_set_id (Worm* self,
                  gint value);
void worm_set_lives (Worm* self,
                     gint value);
void worm_set_score (Worm* self,
                     gint value);
static void worm_set_list (Worm* self,
                    GeeLinkedList* value);
void worm_set_start (Worm* self,
                     gint xhead,
                     gint yhead,
                     WormDirection direction);
GeeLinkedList* worm_get_list (Worm* self);
static void worm_set_starting_position (Worm* self,
                                 Position * value);
void worm_get_starting_position (Worm* self,
                                 Position * result);
void worm_move (Worm* self,
                gint* board,
                int board_length1,
                int board_length2);
void worm_get_head (Worm* self,
                    Position * result);
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_EMPTYCHAR 'a'
gboolean worm_get_is_materialized (Worm* self);
#define NIBBLES_GAME_WORMCHAR 'w'
gint worm_get_id (Worm* self);
void worm_dequeue_keypress (Worm* self);
static void worm_materialize (Worm* self,
                       gint* board,
                       int board_length1,
                       int board_length2);
void worm_reduce_tail (Worm* self,
                       gint* board,
                       int board_length1,
                       int board_length2,
                       gint erase_size);
void worm_reverse (Worm* self,
                   gint* board,
                   int board_length1,
                   int board_length2);
GType warp_get_type (void) G_GNUC_CONST;
void worm_warp (Worm* self,
                Warp* warp);
static void worm_set_head (Worm* self,
                    Position * value);
gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           int board_length1,
                           int board_length2,
                           gint numworms);
static void worm_position_move (Worm* self,
                         Position* result);
gboolean worm_will_collide_with_head (Worm* self,
                                      Worm* other_worm);
static gboolean _position_equal (const Position * s1,
                          const Position * s2);
void worm_spawn (Worm* self,
                 gint* board,
                 int board_length1,
                 int board_length2);
static void worm_set_is_materialized (Worm* self,
                               gboolean value);
void worm_dematerialize (Worm* self,
                         gint* board,
                         int board_length1,
                         int board_length2,
                         gint rounds);
void worm_add_life (Worm* self);
gint worm_get_lives (Worm* self);
static void worm_lose_life (Worm* self);
void worm_reset (Worm* self,
                 gint* board,
                 int board_length1,
                 int board_length2);
static void worm_direction_set (Worm* self,
                         WormDirection dir);
void worm_queue_keypress (Worm* self,
                          WormDirection dir);
static guint worm_upper_key (Worm* self,
                      guint keyval);
void worm_handle_direction (Worm* self,
                            WormDirection dir);
gboolean worm_handle_keypress (Worm* self,
                               guint keyval,
                               GeeHashMap* worm_props);
static gint worm_ai_deadend (gint* board,
                      int board_length1,
                      int board_length2,
                      gint numworms,
                      gint x,
                      gint y,
                      gint length_left);
static gint worm_ai_deadend_after (gint* board,
                            int board_length1,
                            int board_length2,
                            GeeLinkedList* worms,
                            gint numworms,
                            gint x,
                            gint y,
                            gint dir,
                            gint length);
static gboolean worm_ai_too_close (Worm* self,
                            GeeLinkedList* worms,
                            gint numworms);
static gboolean worm_ai_wander (gint* board,
                         int board_length1,
                         int board_length2,
                         gint numworms,
                         gint x,
                         gint y,
                         gint dir,
                         gint ox,
                         gint oy);
GType bonus_type_get_type (void) G_GNUC_CONST;
void worm_ai_move (Worm* self,
                   gint* board,
                   int board_length1,
                   int board_length2,
                   gint numworms,
                   GeeLinkedList* worms);
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
gint worm_get_length (Worm* self);
gint worm_get_score (Worm* self);
void worm_set_length (Worm* self,
                      gint value);
static void worm_finalize (GObject * obj);
static void _vala_worm_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_worm_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);


GType
worm_direction_get_type (void)
{
	static volatile gsize worm_direction_type_id__volatile = 0;
	if (g_once_init_enter (&worm_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{WORM_DIRECTION_NONE, "WORM_DIRECTION_NONE", "none"}, {WORM_DIRECTION_RIGHT, "WORM_DIRECTION_RIGHT", "right"}, {WORM_DIRECTION_DOWN, "WORM_DIRECTION_DOWN", "down"}, {WORM_DIRECTION_LEFT, "WORM_DIRECTION_LEFT", "left"}, {WORM_DIRECTION_UP, "WORM_DIRECTION_UP", "up"}, {0, NULL, NULL}};
		GType worm_direction_type_id;
		worm_direction_type_id = g_enum_register_static ("WormDirection", values);
		g_once_init_leave (&worm_direction_type_id__volatile, worm_direction_type_id);
	}
	return worm_direction_type_id__volatile;
}


Position*
position_dup (const Position* self)
{
	Position* dup;
	dup = g_new0 (Position, 1);
	memcpy (dup, self, sizeof (Position));
	return dup;
}


void
position_free (Position* self)
{
	g_free (self);
}


GType
position_get_type (void)
{
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		GType position_type_id;
		position_type_id = g_boxed_type_register_static ("Position", (GBoxedCopyFunc) position_dup, (GBoxedFreeFunc) position_free);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


WormProperties*
worm_properties_dup (const WormProperties* self)
{
	WormProperties* dup;
	dup = g_new0 (WormProperties, 1);
	memcpy (dup, self, sizeof (WormProperties));
	return dup;
}


void
worm_properties_free (WormProperties* self)
{
	g_free (self);
}


GType
worm_properties_get_type (void)
{
	static volatile gsize worm_properties_type_id__volatile = 0;
	if (g_once_init_enter (&worm_properties_type_id__volatile)) {
		GType worm_properties_type_id;
		worm_properties_type_id = g_boxed_type_register_static ("WormProperties", (GBoxedCopyFunc) worm_properties_dup, (GBoxedFreeFunc) worm_properties_free);
		g_once_init_leave (&worm_properties_type_id__volatile, worm_properties_type_id);
	}
	return worm_properties_type_id__volatile;
}


Worm*
worm_construct (GType object_type,
                gint id)
{
	Worm * self = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeArrayQueue* _tmp2_;
	self = (Worm*) g_object_new (object_type, NULL);
	worm_set_id (self, id);
	worm_set_lives (self, WORM_STARTING_LIVES);
	worm_set_score (self, 0);
	self->change = 0;
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, (GDestroyNotify) position_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	worm_set_list (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_array_queue_new (TYPE_WORM_DIRECTION, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->key_queue);
	self->priv->key_queue = _tmp2_;
	return self;
}


Worm*
worm_new (gint id)
{
	return worm_construct (TYPE_WORM, id);
}


void
worm_set_start (Worm* self,
                gint xhead,
                gint yhead,
                WormDirection direction)
{
	GeeLinkedList* _tmp0_;
	Position _tmp1_ = {0};
	GeeLinkedList* _tmp2_;
	Position _tmp3_;
	WormDirection _tmp4_;
	GeeArrayQueue* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	memset (&_tmp1_, 0, sizeof (Position));
	_tmp1_.x = xhead;
	_tmp1_.y = yhead;
	worm_set_starting_position (self, &_tmp1_);
	_tmp2_ = self->priv->_list;
	_tmp3_ = self->priv->_starting_position;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, &_tmp3_);
	self->starting_direction = direction;
	_tmp4_ = self->starting_direction;
	self->direction = _tmp4_;
	self->change = 0;
	_tmp5_ = self->priv->key_queue;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
}


void
worm_move (Worm* self,
           gint* board,
           int board_length1,
           int board_length2)
{
	gboolean _tmp0_;
	Position position = {0};
	Position _tmp1_ = {0};
	Position _tmp2_;
	WormDirection _tmp3_;
	GeeLinkedList* _tmp36_;
	Position _tmp37_;
	Position _tmp38_ = {0};
	Position _tmp39_;
	gint _tmp40_;
	Position _tmp41_ = {0};
	Position _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	Position _tmp59_ = {0};
	Position _tmp60_;
	gint _tmp61_;
	Position _tmp62_ = {0};
	Position _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp66_;
	GeeArrayQueue* _tmp76_;
	gboolean _tmp77_;
	gboolean _tmp78_;
	gint _tmp79_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_human;
	if (_tmp0_) {
		self->keypress = FALSE;
	}
	worm_get_head (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	position = _tmp2_;
	_tmp3_ = self->direction;
	switch (_tmp3_) {
		case WORM_DIRECTION_UP:
		{
			Position _tmp4_ = {0};
			Position _tmp5_;
			Position _tmp6_ = {0};
			Position _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			Position _tmp10_;
			gint _tmp11_;
			worm_get_head (self, &_tmp4_);
			_tmp5_ = _tmp4_;
			worm_get_head (self, &_tmp6_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_.y;
			_tmp7_.y = _tmp8_ - 1;
			_tmp9_ = _tmp7_.y;
			position.y = _tmp9_;
			_tmp10_ = position;
			_tmp11_ = _tmp10_.y;
			if (_tmp11_ < 0) {
				position.y = NIBBLES_GAME_HEIGHT - 1;
			}
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			Position _tmp12_ = {0};
			Position _tmp13_;
			Position _tmp14_ = {0};
			Position _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Position _tmp18_;
			gint _tmp19_;
			worm_get_head (self, &_tmp12_);
			_tmp13_ = _tmp12_;
			worm_get_head (self, &_tmp14_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_.y;
			_tmp15_.y = _tmp16_ + 1;
			_tmp17_ = _tmp15_.y;
			position.y = _tmp17_;
			_tmp18_ = position;
			_tmp19_ = _tmp18_.y;
			if (_tmp19_ >= NIBBLES_GAME_HEIGHT) {
				position.y = 0;
			}
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			Position _tmp20_ = {0};
			Position _tmp21_;
			Position _tmp22_ = {0};
			Position _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			Position _tmp26_;
			gint _tmp27_;
			worm_get_head (self, &_tmp20_);
			_tmp21_ = _tmp20_;
			worm_get_head (self, &_tmp22_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_.x;
			_tmp23_.x = _tmp24_ - 1;
			_tmp25_ = _tmp23_.x;
			position.x = _tmp25_;
			_tmp26_ = position;
			_tmp27_ = _tmp26_.x;
			if (_tmp27_ < 0) {
				position.x = NIBBLES_GAME_WIDTH - 1;
			}
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			Position _tmp28_ = {0};
			Position _tmp29_;
			Position _tmp30_ = {0};
			Position _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			Position _tmp34_;
			gint _tmp35_;
			worm_get_head (self, &_tmp28_);
			_tmp29_ = _tmp28_;
			worm_get_head (self, &_tmp30_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_.x;
			_tmp31_.x = _tmp32_ + 1;
			_tmp33_ = _tmp31_.x;
			position.x = _tmp33_;
			_tmp34_ = position;
			_tmp35_ = _tmp34_.x;
			if (_tmp35_ >= NIBBLES_GAME_WIDTH) {
				position.x = 0;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp36_ = self->priv->_list;
	_tmp37_ = position;
	gee_deque_offer_head ((GeeDeque*) _tmp36_, &_tmp37_);
	worm_get_head (self, &_tmp38_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_.x;
	worm_get_head (self, &_tmp41_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_.y;
	_tmp44_ = board[(_tmp40_ * board_length2) + _tmp43_];
	if (_tmp44_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
		g_signal_emit (self, worm_signals[WORM_WARP_FOUND_SIGNAL], 0);
	}
	_tmp45_ = self->change;
	if (_tmp45_ > 0) {
		gint _tmp46_;
		_tmp46_ = self->change;
		self->change = _tmp46_ - 1;
		g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
	} else {
		GeeLinkedList* _tmp47_;
		gpointer _tmp48_;
		Position* _tmp49_;
		gint _tmp50_;
		GeeLinkedList* _tmp51_;
		gpointer _tmp52_;
		Position* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		GeeLinkedList* _tmp56_;
		gpointer _tmp57_;
		Position* _tmp58_;
		_tmp47_ = self->priv->_list;
		_tmp48_ = gee_linked_list_last (_tmp47_);
		_tmp49_ = (Position*) _tmp48_;
		_tmp50_ = (*_tmp49_).x;
		_tmp51_ = self->priv->_list;
		_tmp52_ = gee_linked_list_last (_tmp51_);
		_tmp53_ = (Position*) _tmp52_;
		_tmp54_ = (*_tmp53_).y;
		board[(_tmp50_ * board_length2) + _tmp54_] = (gint) NIBBLES_GAME_EMPTYCHAR;
		_tmp55_ = board[(_tmp50_ * board_length2) + _tmp54_];
		_position_free0 (_tmp53_);
		_position_free0 (_tmp49_);
		_tmp56_ = self->priv->_list;
		_tmp57_ = gee_deque_poll_tail ((GeeDeque*) _tmp56_);
		_tmp58_ = (Position*) _tmp57_;
		_position_free0 (_tmp58_);
		g_signal_emit (self, worm_signals[WORM_MOVED_SIGNAL], 0);
	}
	worm_get_head (self, &_tmp59_);
	_tmp60_ = _tmp59_;
	_tmp61_ = _tmp60_.x;
	worm_get_head (self, &_tmp62_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_.y;
	_tmp65_ = board[(_tmp61_ * board_length2) + _tmp64_];
	if (_tmp65_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
		g_signal_emit (self, worm_signals[WORM_BONUS_FOUND_SIGNAL], 0);
	}
	_tmp66_ = self->priv->_is_materialized;
	if (_tmp66_) {
		Position _tmp67_ = {0};
		Position _tmp68_;
		gint _tmp69_;
		Position _tmp70_ = {0};
		Position _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		worm_get_head (self, &_tmp67_);
		_tmp68_ = _tmp67_;
		_tmp69_ = _tmp68_.x;
		worm_get_head (self, &_tmp70_);
		_tmp71_ = _tmp70_;
		_tmp72_ = _tmp71_.y;
		_tmp73_ = self->priv->_id;
		board[(_tmp69_ * board_length2) + _tmp72_] = NIBBLES_GAME_WORMCHAR + _tmp73_;
		_tmp74_ = board[(_tmp69_ * board_length2) + _tmp72_];
	} else {
		gint _tmp75_;
		_tmp75_ = self->priv->rounds_dematerialized;
		self->priv->rounds_dematerialized = _tmp75_ - 1;
	}
	_tmp76_ = self->priv->key_queue;
	_tmp77_ = gee_array_queue_get_is_empty (_tmp76_);
	_tmp78_ = _tmp77_;
	if (!_tmp78_) {
		worm_dequeue_keypress (self);
	}
	_tmp79_ = self->priv->rounds_dematerialized;
	if (_tmp79_ == 1) {
		worm_materialize (self, board, board_length1, board_length2);
	}
}


void
worm_reduce_tail (Worm* self,
                  gint* board,
                  int board_length1,
                  int board_length2,
                  gint erase_size)
{
	g_return_if_fail (self != NULL);
	if (erase_size > 0) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint _tmp2_;
					GeeLinkedList* _tmp3_;
					gpointer _tmp4_;
					Position* _tmp5_;
					gint _tmp6_;
					GeeLinkedList* _tmp7_;
					gpointer _tmp8_;
					Position* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					GeeLinkedList* _tmp12_;
					gpointer _tmp13_;
					Position* _tmp14_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = i;
					if (!(_tmp2_ < erase_size)) {
						break;
					}
					_tmp3_ = self->priv->_list;
					_tmp4_ = gee_linked_list_last (_tmp3_);
					_tmp5_ = (Position*) _tmp4_;
					_tmp6_ = (*_tmp5_).x;
					_tmp7_ = self->priv->_list;
					_tmp8_ = gee_linked_list_last (_tmp7_);
					_tmp9_ = (Position*) _tmp8_;
					_tmp10_ = (*_tmp9_).y;
					board[(_tmp6_ * board_length2) + _tmp10_] = (gint) NIBBLES_GAME_EMPTYCHAR;
					_tmp11_ = board[(_tmp6_ * board_length2) + _tmp10_];
					_position_free0 (_tmp9_);
					_position_free0 (_tmp5_);
					_tmp12_ = self->priv->_list;
					_tmp13_ = gee_deque_poll_tail ((GeeDeque*) _tmp12_);
					_tmp14_ = (Position*) _tmp13_;
					_position_free0 (_tmp14_);
				}
			}
		}
		g_signal_emit (self, worm_signals[WORM_TAIL_REDUCED_SIGNAL], 0, erase_size);
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
worm_reverse (Worm* self,
              gint* board,
              int board_length1,
              int board_length2)
{
	GeeLinkedList* reversed_list = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp14_;
	GeeLinkedList* _tmp15_;
	gpointer _tmp16_;
	Position* _tmp17_;
	gint _tmp18_;
	GeeLinkedList* _tmp19_;
	gpointer _tmp20_;
	Position* _tmp21_;
	gint _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, (GDestroyNotify) position_free, NULL, NULL, NULL);
	reversed_list = _tmp0_;
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index = 0;
		_tmp1_ = self->priv->_list;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_pos_list = _tmp2_;
		_tmp3_ = _pos_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pos_size = _tmp5_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			GeeLinkedList* _tmp12_;
			Position* _tmp13_;
			_tmp6_ = _pos_index;
			_pos_index = _tmp6_ + 1;
			_tmp7_ = _pos_index;
			_tmp8_ = _pos_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pos_list;
			_tmp10_ = _pos_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			pos = (Position*) _tmp11_;
			_tmp12_ = reversed_list;
			_tmp13_ = pos;
			gee_deque_offer_head ((GeeDeque*) _tmp12_, _tmp13_);
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	g_signal_emit (self, worm_signals[WORM_REVERSED_SIGNAL], 0);
	_tmp14_ = reversed_list;
	worm_set_list (self, _tmp14_);
	_tmp15_ = self->priv->_list;
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
	_tmp17_ = (Position*) _tmp16_;
	_tmp18_ = (*_tmp17_).y;
	_tmp19_ = self->priv->_list;
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 1);
	_tmp21_ = (Position*) _tmp20_;
	_tmp22_ = (*_tmp21_).y;
	_tmp23_ = _tmp18_ == _tmp22_;
	_position_free0 (_tmp21_);
	_position_free0 (_tmp17_);
	if (_tmp23_) {
		WormDirection _tmp24_ = 0;
		GeeLinkedList* _tmp25_;
		gpointer _tmp26_;
		Position* _tmp27_;
		gint _tmp28_;
		GeeLinkedList* _tmp29_;
		gpointer _tmp30_;
		Position* _tmp31_;
		gint _tmp32_;
		gboolean _tmp33_;
		_tmp25_ = self->priv->_list;
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
		_tmp27_ = (Position*) _tmp26_;
		_tmp28_ = (*_tmp27_).x;
		_tmp29_ = self->priv->_list;
		_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 1);
		_tmp31_ = (Position*) _tmp30_;
		_tmp32_ = (*_tmp31_).x;
		_tmp33_ = _tmp28_ > _tmp32_;
		_position_free0 (_tmp31_);
		_position_free0 (_tmp27_);
		if (_tmp33_) {
			_tmp24_ = WORM_DIRECTION_RIGHT;
		} else {
			_tmp24_ = WORM_DIRECTION_LEFT;
		}
		self->direction = _tmp24_;
	} else {
		WormDirection _tmp34_ = 0;
		GeeLinkedList* _tmp35_;
		gpointer _tmp36_;
		Position* _tmp37_;
		gint _tmp38_;
		GeeLinkedList* _tmp39_;
		gpointer _tmp40_;
		Position* _tmp41_;
		gint _tmp42_;
		gboolean _tmp43_;
		_tmp35_ = self->priv->_list;
		_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
		_tmp37_ = (Position*) _tmp36_;
		_tmp38_ = (*_tmp37_).y;
		_tmp39_ = self->priv->_list;
		_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 1);
		_tmp41_ = (Position*) _tmp40_;
		_tmp42_ = (*_tmp41_).y;
		_tmp43_ = _tmp38_ > _tmp42_;
		_position_free0 (_tmp41_);
		_position_free0 (_tmp37_);
		if (_tmp43_) {
			_tmp34_ = WORM_DIRECTION_DOWN;
		} else {
			_tmp34_ = WORM_DIRECTION_UP;
		}
		self->direction = _tmp34_;
	}
	_g_object_unref0 (reversed_list);
}


void
worm_warp (Worm* self,
           Warp* warp)
{
	gint _tmp0_;
	gint _tmp1_;
	Position _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (warp != NULL);
	_tmp0_ = warp->wx;
	_tmp1_ = warp->wy;
	memset (&_tmp2_, 0, sizeof (Position));
	_tmp2_.x = _tmp0_;
	_tmp2_.y = _tmp1_;
	worm_set_head (self, &_tmp2_);
}


gboolean
worm_can_move_to (Worm* self,
                  gint* board,
                  int board_length1,
                  int board_length2,
                  gint numworms)
{
	gboolean result = FALSE;
	Position position = {0};
	Position _tmp0_ = {0};
	gint next_position = 0;
	Position _tmp1_;
	gint _tmp2_;
	Position _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	worm_position_move (self, &_tmp0_);
	position = _tmp0_;
	_tmp1_ = position;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = position;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = board[(_tmp2_ * board_length2) + _tmp4_];
	next_position = _tmp5_;
	_tmp7_ = next_position;
	if (_tmp7_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
		gint _tmp8_;
		_tmp8_ = next_position;
		_tmp6_ = _tmp8_ < ((gint) NIBBLES_GAME_WORMCHAR);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = next_position;
	if (_tmp10_ >= ((gint) NIBBLES_GAME_WORMCHAR)) {
		gint _tmp11_;
		_tmp11_ = next_position;
		_tmp9_ = _tmp11_ < (NIBBLES_GAME_WORMCHAR + numworms);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp12_;
		_tmp12_ = self->priv->_is_materialized;
		result = !_tmp12_;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean
_position_equal (const Position * s1,
                 const Position * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	return TRUE;
}


gboolean
worm_will_collide_with_head (Worm* self,
                             Worm* other_worm)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Position worm_pos = {0};
	Position _tmp3_ = {0};
	Position other_worm_pos = {0};
	Position _tmp4_ = {0};
	Position _tmp5_;
	Position _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other_worm != NULL, FALSE);
	_tmp1_ = self->priv->_is_materialized;
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = other_worm->priv->_is_materialized;
		_tmp0_ = !_tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	worm_position_move (self, &_tmp3_);
	worm_pos = _tmp3_;
	worm_position_move (other_worm, &_tmp4_);
	other_worm_pos = _tmp4_;
	_tmp5_ = worm_pos;
	_tmp6_ = other_worm_pos;
	if (_position_equal (&_tmp5_, &_tmp6_) == TRUE) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void
worm_spawn (Worm* self,
            gint* board,
            int board_length1,
            int board_length2)
{
	g_return_if_fail (self != NULL);
	self->change = WORM_STARTING_LENGTH - 1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < WORM_STARTING_LENGTH)) {
					break;
				}
				worm_move (self, board, board_length1, board_length2);
			}
		}
	}
}


static void
worm_materialize (Worm* self,
                  gint* board,
                  int board_length1,
                  int board_length2)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index = 0;
		_tmp0_ = self->priv->_list;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_pos_list = _tmp1_;
		_tmp2_ = _pos_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pos_size = _tmp4_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Position* pos = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Position* _tmp11_;
			gint _tmp12_;
			Position* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp5_ = _pos_index;
			_pos_index = _tmp5_ + 1;
			_tmp6_ = _pos_index;
			_tmp7_ = _pos_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pos_list;
			_tmp9_ = _pos_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			pos = (Position*) _tmp10_;
			_tmp11_ = pos;
			_tmp12_ = (*_tmp11_).x;
			_tmp13_ = pos;
			_tmp14_ = (*_tmp13_).y;
			_tmp15_ = board[(_tmp12_ * board_length2) + _tmp14_];
			if (_tmp15_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				gint _tmp16_;
				_tmp16_ = self->priv->rounds_dematerialized;
				self->priv->rounds_dematerialized = _tmp16_ + 1;
				_position_free0 (pos);
				_g_object_unref0 (_pos_list);
				return;
			}
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp17_;
		GeeLinkedList* _tmp18_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _pos_index = 0;
		_tmp17_ = self->priv->_list;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_pos_list = _tmp18_;
		_tmp19_ = _pos_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_pos_size = _tmp21_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			Position* pos = NULL;
			GeeLinkedList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			Position* _tmp28_;
			gint _tmp29_;
			Position* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp22_ = _pos_index;
			_pos_index = _tmp22_ + 1;
			_tmp23_ = _pos_index;
			_tmp24_ = _pos_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _pos_list;
			_tmp26_ = _pos_index;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
			pos = (Position*) _tmp27_;
			_tmp28_ = pos;
			_tmp29_ = (*_tmp28_).x;
			_tmp30_ = pos;
			_tmp31_ = (*_tmp30_).y;
			_tmp32_ = self->priv->_id;
			board[(_tmp29_ * board_length2) + _tmp31_] = NIBBLES_GAME_WORMCHAR + _tmp32_;
			_tmp33_ = board[(_tmp29_ * board_length2) + _tmp31_];
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	worm_set_is_materialized (self, TRUE);
	self->priv->rounds_dematerialized = 0;
}


void
worm_dematerialize (Worm* self,
                    gint* board,
                    int board_length1,
                    int board_length2,
                    gint rounds)
{
	g_return_if_fail (self != NULL);
	self->priv->rounds_dematerialized = rounds;
	worm_set_is_materialized (self, FALSE);
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index = 0;
		_tmp0_ = self->priv->_list;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_pos_list = _tmp1_;
		_tmp2_ = _pos_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pos_size = _tmp4_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Position* pos = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Position* _tmp11_;
			gint _tmp12_;
			Position* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp5_ = _pos_index;
			_pos_index = _tmp5_ + 1;
			_tmp6_ = _pos_index;
			_tmp7_ = _pos_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pos_list;
			_tmp9_ = _pos_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			pos = (Position*) _tmp10_;
			_tmp11_ = pos;
			_tmp12_ = (*_tmp11_).x;
			_tmp13_ = pos;
			_tmp14_ = (*_tmp13_).y;
			_tmp15_ = board[(_tmp12_ * board_length2) + _tmp14_];
			_tmp16_ = self->priv->_id;
			if (_tmp15_ == (NIBBLES_GAME_WORMCHAR + _tmp16_)) {
				Position* _tmp17_;
				gint _tmp18_;
				Position* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				_tmp17_ = pos;
				_tmp18_ = (*_tmp17_).x;
				_tmp19_ = pos;
				_tmp20_ = (*_tmp19_).y;
				board[(_tmp18_ * board_length2) + _tmp20_] = (gint) NIBBLES_GAME_EMPTYCHAR;
				_tmp21_ = board[(_tmp18_ * board_length2) + _tmp20_];
			}
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
}


void
worm_add_life (Worm* self)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_lives;
	if (_tmp0_ > WORM_MAX_LIVES) {
		return;
	}
	_tmp1_ = self->priv->_lives;
	worm_set_lives (self, _tmp1_ + 1);
}


static void
worm_lose_life (Worm* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_lives;
	worm_set_lives (self, _tmp0_ - 1);
}


void
worm_reset (Worm* self,
            gint* board,
            int board_length1,
            int board_length2)
{
	GeeArrayQueue* _tmp0_;
	GeeLinkedList* _tmp17_;
	GeeLinkedList* _tmp18_;
	Position _tmp19_;
	WormDirection _tmp20_;
	g_return_if_fail (self != NULL);
	self->is_stopped = TRUE;
	worm_set_is_materialized (self, FALSE);
	self->priv->rounds_dematerialized = 0;
	_tmp0_ = self->priv->key_queue;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	worm_lose_life (self);
	g_signal_emit (self, worm_signals[WORM_DIED_SIGNAL], 0);
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index = 0;
		_tmp1_ = self->priv->_list;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_pos_list = _tmp2_;
		_tmp3_ = _pos_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pos_size = _tmp5_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			Position* _tmp12_;
			gint _tmp13_;
			Position* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp6_ = _pos_index;
			_pos_index = _tmp6_ + 1;
			_tmp7_ = _pos_index;
			_tmp8_ = _pos_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pos_list;
			_tmp10_ = _pos_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			pos = (Position*) _tmp11_;
			_tmp12_ = pos;
			_tmp13_ = (*_tmp12_).x;
			_tmp14_ = pos;
			_tmp15_ = (*_tmp14_).y;
			board[(_tmp13_ * board_length2) + _tmp15_] = (gint) NIBBLES_GAME_EMPTYCHAR;
			_tmp16_ = board[(_tmp13_ * board_length2) + _tmp15_];
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	_tmp17_ = self->priv->_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp17_);
	_tmp18_ = self->priv->_list;
	_tmp19_ = self->priv->_starting_position;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, &_tmp19_);
	g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
	_tmp20_ = self->starting_direction;
	self->direction = _tmp20_;
	self->change = 0;
	worm_spawn (self, board, board_length1, board_length2);
	g_signal_emit (self, worm_signals[WORM_FINISH_ADDED_SIGNAL], 0);
}


static void
worm_position_move (Worm* self,
                    Position* result)
{
	Position position = {0};
	Position _tmp0_ = {0};
	Position _tmp1_;
	WormDirection _tmp2_;
	g_return_if_fail (self != NULL);
	worm_get_head (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	position = _tmp1_;
	_tmp2_ = self->direction;
	switch (_tmp2_) {
		case WORM_DIRECTION_UP:
		{
			Position _tmp3_ = {0};
			Position _tmp4_;
			Position _tmp5_ = {0};
			Position _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position _tmp9_;
			gint _tmp10_;
			worm_get_head (self, &_tmp3_);
			_tmp4_ = _tmp3_;
			worm_get_head (self, &_tmp5_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _tmp6_.y;
			_tmp6_.y = _tmp7_ - 1;
			_tmp8_ = _tmp6_.y;
			position.y = _tmp8_;
			_tmp9_ = position;
			_tmp10_ = _tmp9_.y;
			if (_tmp10_ < 0) {
				position.y = NIBBLES_GAME_HEIGHT - 1;
			}
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			Position _tmp11_ = {0};
			Position _tmp12_;
			Position _tmp13_ = {0};
			Position _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			Position _tmp17_;
			gint _tmp18_;
			worm_get_head (self, &_tmp11_);
			_tmp12_ = _tmp11_;
			worm_get_head (self, &_tmp13_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_.y;
			_tmp14_.y = _tmp15_ + 1;
			_tmp16_ = _tmp14_.y;
			position.y = _tmp16_;
			_tmp17_ = position;
			_tmp18_ = _tmp17_.y;
			if (_tmp18_ >= NIBBLES_GAME_HEIGHT) {
				position.y = 0;
			}
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			Position _tmp19_ = {0};
			Position _tmp20_;
			Position _tmp21_ = {0};
			Position _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			Position _tmp25_;
			gint _tmp26_;
			worm_get_head (self, &_tmp19_);
			_tmp20_ = _tmp19_;
			worm_get_head (self, &_tmp21_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_.x;
			_tmp22_.x = _tmp23_ - 1;
			_tmp24_ = _tmp22_.x;
			position.x = _tmp24_;
			_tmp25_ = position;
			_tmp26_ = _tmp25_.x;
			if (_tmp26_ < 0) {
				position.x = NIBBLES_GAME_WIDTH - 1;
			}
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			Position _tmp27_ = {0};
			Position _tmp28_;
			Position _tmp29_ = {0};
			Position _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			Position _tmp33_;
			gint _tmp34_;
			worm_get_head (self, &_tmp27_);
			_tmp28_ = _tmp27_;
			worm_get_head (self, &_tmp29_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_.x;
			_tmp30_.x = _tmp31_ + 1;
			_tmp32_ = _tmp30_.x;
			position.x = _tmp32_;
			_tmp33_ = position;
			_tmp34_ = _tmp33_.x;
			if (_tmp34_ >= NIBBLES_GAME_WIDTH) {
				position.x = 0;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	*result = position;
	return;
}


static void
worm_direction_set (Worm* self,
                    WormDirection dir)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_human;
	if (!_tmp0_) {
		return;
	}
	if (dir > 4) {
		dir = (WormDirection) 1;
	}
	if (dir < 1) {
		dir = (WormDirection) 4;
	}
	_tmp1_ = self->keypress;
	if (_tmp1_) {
		worm_queue_keypress (self, dir);
		return;
	}
	self->direction = (WormDirection) dir;
	self->keypress = TRUE;
}


static guint
worm_upper_key (Worm* self,
                guint keyval)
{
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	if (keyval > ((guint) 255)) {
		result = keyval;
		return result;
	}
	result = (guint) g_ascii_toupper ((gchar) keyval);
	return result;
}


void
worm_handle_direction (Worm* self,
                       WormDirection dir)
{
	g_return_if_fail (self != NULL);
	worm_direction_set (self, dir);
}


gboolean
worm_handle_keypress (Worm* self,
                      guint keyval,
                      GeeHashMap* worm_props)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	WormProperties properties = {0};
	guint propsUp = 0U;
	guint propsDown = 0U;
	guint propsLeft = 0U;
	guint propsRight = 0U;
	guint keyvalUpper = 0U;
	gpointer _tmp3_;
	WormProperties* _tmp4_;
	WormProperties _tmp5_;
	guint _tmp6_;
	WormProperties _tmp7_;
	guint _tmp8_;
	WormProperties _tmp9_;
	guint _tmp10_;
	WormProperties _tmp11_;
	guint _tmp12_;
	gboolean _tmp13_ = FALSE;
	guint _tmp14_;
	guint _tmp15_;
	gboolean _tmp17_ = FALSE;
	guint _tmp18_;
	guint _tmp19_;
	gboolean _tmp21_ = FALSE;
	guint _tmp22_;
	guint _tmp23_;
	gboolean _tmp25_ = FALSE;
	guint _tmp26_;
	guint _tmp27_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (worm_props != NULL, FALSE);
	_tmp1_ = self->priv->_lives;
	if (_tmp1_ <= 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->is_stopped;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) worm_props, self);
	_tmp4_ = (WormProperties*) _tmp3_;
	properties = *_tmp4_;
	_worm_properties_free0 (_tmp4_);
	_tmp5_ = properties;
	_tmp6_ = _tmp5_.up;
	propsUp = worm_upper_key (self, _tmp6_);
	_tmp7_ = properties;
	_tmp8_ = _tmp7_.left;
	propsLeft = worm_upper_key (self, _tmp8_);
	_tmp9_ = properties;
	_tmp10_ = _tmp9_.down;
	propsDown = worm_upper_key (self, _tmp10_);
	_tmp11_ = properties;
	_tmp12_ = _tmp11_.right;
	propsRight = worm_upper_key (self, _tmp12_);
	keyvalUpper = worm_upper_key (self, keyval);
	_tmp14_ = keyvalUpper;
	_tmp15_ = propsUp;
	if (_tmp14_ == _tmp15_) {
		WormDirection _tmp16_;
		_tmp16_ = self->direction;
		_tmp13_ = _tmp16_ != WORM_DIRECTION_DOWN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		worm_handle_direction (self, WORM_DIRECTION_UP);
		result = TRUE;
		return result;
	}
	_tmp18_ = keyvalUpper;
	_tmp19_ = propsDown;
	if (_tmp18_ == _tmp19_) {
		WormDirection _tmp20_;
		_tmp20_ = self->direction;
		_tmp17_ = _tmp20_ != WORM_DIRECTION_UP;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		worm_handle_direction (self, WORM_DIRECTION_DOWN);
		result = TRUE;
		return result;
	}
	_tmp22_ = keyvalUpper;
	_tmp23_ = propsRight;
	if (_tmp22_ == _tmp23_) {
		WormDirection _tmp24_;
		_tmp24_ = self->direction;
		_tmp21_ = _tmp24_ != WORM_DIRECTION_LEFT;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		worm_handle_direction (self, WORM_DIRECTION_RIGHT);
		result = TRUE;
		return result;
	}
	_tmp26_ = keyvalUpper;
	_tmp27_ = propsLeft;
	if (_tmp26_ == _tmp27_) {
		WormDirection _tmp28_;
		_tmp28_ = self->direction;
		_tmp25_ = _tmp28_ != WORM_DIRECTION_RIGHT;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		worm_handle_direction (self, WORM_DIRECTION_LEFT);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void
worm_queue_keypress (Worm* self,
                     WormDirection dir)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayQueue* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeArrayQueue* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->key_queue;
	_tmp2_ = gee_array_queue_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GeeArrayQueue* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->priv->key_queue;
		_tmp5_ = gee_abstract_queue_peek ((GeeAbstractQueue*) _tmp4_);
		_tmp0_ = dir == ((WormDirection) ((gintptr) _tmp5_));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->key_queue;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) dir));
}


void
worm_dequeue_keypress (Worm* self)
{
	GeeArrayQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayQueue* _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_queue;
	_tmp1_ = gee_array_queue_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (!_tmp2_, "!key_queue.is_empty");
	_tmp3_ = self->priv->key_queue;
	_tmp4_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp3_);
	worm_direction_set (self, (WormDirection) ((gintptr) _tmp4_));
}


static gint
worm_ai_deadend (gint* board,
                 int board_length1,
                 int board_length2,
                 gint numworms,
                 gint x,
                 gint y,
                 gint length_left)
{
	gint result = 0;
	gint cdir = 0;
	gint cx = 0;
	gint cy = 0;
	if (x >= NIBBLES_GAME_WIDTH) {
		x = 0;
	}
	if (x < 0) {
		x = NIBBLES_GAME_WIDTH - 1;
	}
	if (y >= NIBBLES_GAME_HEIGHT) {
		y = 0;
	}
	if (y < 0) {
		y = NIBBLES_GAME_HEIGHT - 1;
	}
	if (length_left <= 0) {
		result = 0;
		return result;
	}
	cdir = 5;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp0_ = cdir;
		cdir = _tmp0_ - 1;
		_tmp1_ = cdir;
		if (!(_tmp1_ > 0)) {
			break;
		}
		cx = x;
		cy = y;
		_tmp2_ = cdir;
		switch (_tmp2_) {
			case WORM_DIRECTION_UP:
			{
				gint _tmp3_;
				_tmp3_ = cy;
				cy = _tmp3_ - 1;
				break;
			}
			case WORM_DIRECTION_DOWN:
			{
				gint _tmp4_;
				_tmp4_ = cy;
				cy = _tmp4_ + 1;
				break;
			}
			case WORM_DIRECTION_LEFT:
			{
				gint _tmp5_;
				_tmp5_ = cx;
				cx = _tmp5_ - 1;
				break;
			}
			case WORM_DIRECTION_RIGHT:
			{
				gint _tmp6_;
				_tmp6_ = cx;
				cx = _tmp6_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp7_ = cx;
		if (_tmp7_ >= NIBBLES_GAME_WIDTH) {
			cx = 0;
		}
		_tmp8_ = cx;
		if (_tmp8_ < 0) {
			cx = NIBBLES_GAME_WIDTH - 1;
		}
		_tmp9_ = cy;
		if (_tmp9_ >= NIBBLES_GAME_HEIGHT) {
			cy = 0;
		}
		_tmp10_ = cy;
		if (_tmp10_ < 0) {
			cy = NIBBLES_GAME_HEIGHT - 1;
		}
		_tmp13_ = cx;
		_tmp14_ = cy;
		_tmp15_ = board[(_tmp13_ * board_length2) + _tmp14_];
		if (_tmp15_ <= ((gint) NIBBLES_GAME_EMPTYCHAR)) {
			_tmp12_ = TRUE;
		} else {
			gint _tmp16_;
			_tmp16_ = board[(x * board_length2) + y];
			_tmp12_ = _tmp16_ >= ('z' + numworms);
		}
		if (_tmp12_) {
			guint* _tmp17_;
			gint _tmp17__length1;
			gint _tmp17__length2;
			gint _tmp18_;
			gint _tmp19_;
			guint _tmp20_;
			guint _tmp21_;
			_tmp17_ = worm_deadend_board;
			_tmp17__length1 = worm_deadend_board_length1;
			_tmp17__length2 = worm_deadend_board_length2;
			_tmp18_ = cx;
			_tmp19_ = cy;
			_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
			_tmp21_ = worm_deadend_runnumber;
			_tmp11_ = _tmp20_ != _tmp21_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			guint* _tmp22_;
			gint _tmp22__length1;
			gint _tmp22__length2;
			gint _tmp23_;
			gint _tmp24_;
			guint _tmp25_;
			guint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp22_ = worm_deadend_board;
			_tmp22__length1 = worm_deadend_board_length1;
			_tmp22__length2 = worm_deadend_board_length2;
			_tmp23_ = cx;
			_tmp24_ = cy;
			_tmp25_ = worm_deadend_runnumber;
			_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = _tmp25_;
			_tmp26_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
			_tmp27_ = cx;
			_tmp28_ = cy;
			length_left = worm_ai_deadend (board, board_length1, board_length2, numworms, _tmp27_, _tmp28_, length_left - 1);
			if (length_left <= 0) {
				result = 0;
				return result;
			}
		}
	}
	result = length_left;
	return result;
}


static gint
worm_ai_deadend_after (gint* board,
                       int board_length1,
                       int board_length2,
                       GeeLinkedList* worms,
                       gint numworms,
                       gint x,
                       gint y,
                       gint dir,
                       gint length)
{
	gint result = 0;
	gint cx = 0;
	gint cy = 0;
	gint cl = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	gint _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	guint* _tmp52_;
	gint _tmp52__length1;
	gint _tmp52__length2;
	guint _tmp53_;
	guint _tmp54_;
	guint* _tmp55_;
	gint _tmp55__length1;
	gint _tmp55__length2;
	gint _tmp56_;
	gint _tmp57_;
	guint _tmp58_;
	guint _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	g_return_val_if_fail (worms != NULL, 0);
	if (x < 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = x >= NIBBLES_GAME_WIDTH;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y >= NIBBLES_GAME_HEIGHT;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp3_ = worm_deadend_runnumber;
	worm_deadend_runnumber = _tmp3_ + 1;
	if (dir > 4) {
		dir = 1;
	}
	if (dir < 1) {
		dir = 4;
	}
	i = numworms;
	while (TRUE) {
		gint _tmp4_;
		gint _tmp5_;
		gpointer _tmp6_;
		Worm* _tmp7_;
		Position _tmp8_ = {0};
		Position _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gpointer _tmp12_;
		Worm* _tmp13_;
		Position _tmp14_ = {0};
		Position _tmp15_;
		gint _tmp16_;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_;
		_tmp4_ = i;
		i = _tmp4_ - 1;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp5_);
		_tmp7_ = (Worm*) _tmp6_;
		worm_get_head (_tmp7_, &_tmp8_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_.x;
		cx = _tmp10_;
		_g_object_unref0 (_tmp7_);
		_tmp11_ = i;
		_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp11_);
		_tmp13_ = (Worm*) _tmp12_;
		worm_get_head (_tmp13_, &_tmp14_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_.y;
		cy = _tmp16_;
		_g_object_unref0 (_tmp13_);
		_tmp18_ = cx;
		if (_tmp18_ != x) {
			_tmp17_ = TRUE;
		} else {
			gint _tmp19_;
			_tmp19_ = cy;
			_tmp17_ = _tmp19_ != y;
		}
		if (_tmp17_) {
			gint _tmp20_;
			gint _tmp26_;
			gint _tmp32_;
			gint _tmp38_;
			_tmp20_ = cx;
			if (_tmp20_ > 0) {
				guint* _tmp21_;
				gint _tmp21__length1;
				gint _tmp21__length2;
				gint _tmp22_;
				gint _tmp23_;
				guint _tmp24_;
				guint _tmp25_;
				_tmp21_ = worm_deadend_board;
				_tmp21__length1 = worm_deadend_board_length1;
				_tmp21__length2 = worm_deadend_board_length2;
				_tmp22_ = cx;
				_tmp23_ = cy;
				_tmp24_ = worm_deadend_runnumber;
				_tmp21_[((_tmp22_ - 1) * _tmp21__length2) + _tmp23_] = _tmp24_;
				_tmp25_ = _tmp21_[((_tmp22_ - 1) * _tmp21__length2) + _tmp23_];
			}
			_tmp26_ = cy;
			if (_tmp26_ > 0) {
				guint* _tmp27_;
				gint _tmp27__length1;
				gint _tmp27__length2;
				gint _tmp28_;
				gint _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
				_tmp27_ = worm_deadend_board;
				_tmp27__length1 = worm_deadend_board_length1;
				_tmp27__length2 = worm_deadend_board_length2;
				_tmp28_ = cx;
				_tmp29_ = cy;
				_tmp30_ = worm_deadend_runnumber;
				_tmp27_[(_tmp28_ * _tmp27__length2) + (_tmp29_ - 1)] = _tmp30_;
				_tmp31_ = _tmp27_[(_tmp28_ * _tmp27__length2) + (_tmp29_ - 1)];
			}
			_tmp32_ = cx;
			if (_tmp32_ < (NIBBLES_GAME_WIDTH - 1)) {
				guint* _tmp33_;
				gint _tmp33__length1;
				gint _tmp33__length2;
				gint _tmp34_;
				gint _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
				_tmp33_ = worm_deadend_board;
				_tmp33__length1 = worm_deadend_board_length1;
				_tmp33__length2 = worm_deadend_board_length2;
				_tmp34_ = cx;
				_tmp35_ = cy;
				_tmp36_ = worm_deadend_runnumber;
				_tmp33_[((_tmp34_ + 1) * _tmp33__length2) + _tmp35_] = _tmp36_;
				_tmp37_ = _tmp33_[((_tmp34_ + 1) * _tmp33__length2) + _tmp35_];
			}
			_tmp38_ = cy;
			if (_tmp38_ < (NIBBLES_GAME_HEIGHT - 1)) {
				guint* _tmp39_;
				gint _tmp39__length1;
				gint _tmp39__length2;
				gint _tmp40_;
				gint _tmp41_;
				guint _tmp42_;
				guint _tmp43_;
				_tmp39_ = worm_deadend_board;
				_tmp39__length1 = worm_deadend_board_length1;
				_tmp39__length2 = worm_deadend_board_length2;
				_tmp40_ = cx;
				_tmp41_ = cy;
				_tmp42_ = worm_deadend_runnumber;
				_tmp39_[(_tmp40_ * _tmp39__length2) + (_tmp41_ + 1)] = _tmp42_;
				_tmp43_ = _tmp39_[(_tmp40_ * _tmp39__length2) + (_tmp41_ + 1)];
			}
		}
	}
	cx = x;
	cy = y;
	switch (dir) {
		case WORM_DIRECTION_UP:
		{
			gint _tmp44_;
			_tmp44_ = cy;
			cy = _tmp44_ - 1;
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			gint _tmp45_;
			_tmp45_ = cy;
			cy = _tmp45_ + 1;
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			gint _tmp46_;
			_tmp46_ = cx;
			cx = _tmp46_ - 1;
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			gint _tmp47_;
			_tmp47_ = cx;
			cx = _tmp47_ + 1;
			break;
		}
		default:
		break;
	}
	_tmp48_ = cx;
	if (_tmp48_ >= NIBBLES_GAME_WIDTH) {
		cx = 0;
	}
	_tmp49_ = cx;
	if (_tmp49_ < 0) {
		cx = NIBBLES_GAME_WIDTH - 1;
	}
	_tmp50_ = cy;
	if (_tmp50_ >= NIBBLES_GAME_HEIGHT) {
		cy = 0;
	}
	_tmp51_ = cy;
	if (_tmp51_ < 0) {
		cy = NIBBLES_GAME_HEIGHT - 1;
	}
	_tmp52_ = worm_deadend_board;
	_tmp52__length1 = worm_deadend_board_length1;
	_tmp52__length2 = worm_deadend_board_length2;
	_tmp53_ = worm_deadend_runnumber;
	_tmp52_[(x * _tmp52__length2) + y] = _tmp53_;
	_tmp54_ = _tmp52_[(x * _tmp52__length2) + y];
	_tmp55_ = worm_deadend_board;
	_tmp55__length1 = worm_deadend_board_length1;
	_tmp55__length2 = worm_deadend_board_length2;
	_tmp56_ = cx;
	_tmp57_ = cy;
	_tmp58_ = worm_deadend_runnumber;
	_tmp55_[(_tmp56_ * _tmp55__length2) + _tmp57_] = _tmp58_;
	_tmp59_ = _tmp55_[(_tmp56_ * _tmp55__length2) + _tmp57_];
	cl = (length * length) / 16;
	_tmp60_ = cl;
	if (_tmp60_ < NIBBLES_GAME_WIDTH) {
		cl = NIBBLES_GAME_WIDTH;
	}
	_tmp61_ = cx;
	_tmp62_ = cy;
	_tmp63_ = cl;
	result = worm_ai_deadend (board, board_length1, board_length2, numworms, _tmp61_, _tmp62_, _tmp63_);
	return result;
}


static gboolean
worm_ai_too_close (Worm* self,
                   GeeLinkedList* worms,
                   gint numworms)
{
	gboolean result = FALSE;
	gint i = 0;
	gint dx = 0;
	gint dy = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (worms != NULL, FALSE);
	i = numworms;
	while (TRUE) {
		gint _tmp0_;
		Position _tmp1_ = {0};
		Position _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_;
		Worm* _tmp6_;
		Position _tmp7_ = {0};
		Position _tmp8_;
		gint _tmp9_;
		Position _tmp10_ = {0};
		Position _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gpointer _tmp14_;
		Worm* _tmp15_;
		Position _tmp16_ = {0};
		Position _tmp17_;
		gint _tmp18_;
		WormDirection _tmp19_;
		_tmp0_ = i;
		i = _tmp0_ - 1;
		if (!(_tmp0_ > 0)) {
			break;
		}
		worm_get_head (self, &_tmp1_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_.x;
		_tmp4_ = i;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp4_);
		_tmp6_ = (Worm*) _tmp5_;
		worm_get_head (_tmp6_, &_tmp7_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_.x;
		dx = _tmp3_ - _tmp9_;
		_g_object_unref0 (_tmp6_);
		worm_get_head (self, &_tmp10_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_.y;
		_tmp13_ = i;
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) worms, _tmp13_);
		_tmp15_ = (Worm*) _tmp14_;
		worm_get_head (_tmp15_, &_tmp16_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_.y;
		dy = _tmp12_ - _tmp18_;
		_g_object_unref0 (_tmp15_);
		_tmp19_ = self->direction;
		switch (_tmp19_) {
			case WORM_DIRECTION_UP:
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_;
				_tmp23_ = dy;
				if (_tmp23_ > 0) {
					gint _tmp24_;
					_tmp24_ = dy;
					_tmp22_ = _tmp24_ <= 3;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					gint _tmp25_;
					_tmp25_ = dx;
					_tmp21_ = _tmp25_ >= -1;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					gint _tmp26_;
					_tmp26_ = dx;
					_tmp20_ = _tmp26_ <= 1;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					result = TRUE;
					return result;
				}
				break;
			}
			case WORM_DIRECTION_DOWN:
			{
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gint _tmp30_;
				_tmp30_ = dy;
				if (_tmp30_ < 0) {
					gint _tmp31_;
					_tmp31_ = dy;
					_tmp29_ = _tmp31_ >= -3;
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					gint _tmp32_;
					_tmp32_ = dx;
					_tmp28_ = _tmp32_ >= -1;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					gint _tmp33_;
					_tmp33_ = dx;
					_tmp27_ = _tmp33_ <= 1;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					result = TRUE;
					return result;
				}
				break;
			}
			case WORM_DIRECTION_LEFT:
			{
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				_tmp37_ = dx;
				if (_tmp37_ > 0) {
					gint _tmp38_;
					_tmp38_ = dx;
					_tmp36_ = _tmp38_ <= 3;
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					gint _tmp39_;
					_tmp39_ = dy;
					_tmp35_ = _tmp39_ >= -1;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					gint _tmp40_;
					_tmp40_ = dy;
					_tmp34_ = _tmp40_ <= 1;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					result = TRUE;
					return result;
				}
				break;
			}
			case WORM_DIRECTION_RIGHT:
			{
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gint _tmp44_;
				_tmp44_ = dx;
				if (_tmp44_ < 0) {
					gint _tmp45_;
					_tmp45_ = dx;
					_tmp43_ = _tmp45_ >= -3;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					gint _tmp46_;
					_tmp46_ = dy;
					_tmp42_ = _tmp46_ >= -1;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					gint _tmp47_;
					_tmp47_ = dy;
					_tmp41_ = _tmp47_ <= 1;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					result = TRUE;
					return result;
				}
				break;
			}
			default:
			break;
		}
	}
	result = FALSE;
	return result;
}


static gboolean
worm_ai_wander (gint* board,
                int board_length1,
                int board_length2,
                gint numworms,
                gint x,
                gint y,
                gint dir,
                gint ox,
                gint oy)
{
	gboolean result = FALSE;
	gint _tmp0_;
	if (dir > 4) {
		dir = 1;
	}
	if (dir < 1) {
		dir = 4;
	}
	switch (dir) {
		case WORM_DIRECTION_UP:
		{
			y = y - 1;
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			y = y + 1;
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			x = x - 1;
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			x = x + 1;
			break;
		}
		default:
		break;
	}
	if (x >= NIBBLES_GAME_WIDTH) {
		x = 0;
	}
	if (x < 0) {
		x = NIBBLES_GAME_WIDTH - 1;
	}
	if (y >= NIBBLES_GAME_HEIGHT) {
		y = 0;
	}
	if (y < 0) {
		y = NIBBLES_GAME_HEIGHT - 1;
	}
	_tmp0_ = board[(x * board_length2) + y];
	switch (_tmp0_ - 'A') {
		case BONUS_TYPE_REGULAR:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_DOUBLE:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_LIFE:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_REVERSE:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_HALF:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			_tmp2_ = board[(x * board_length2) + y];
			if (_tmp2_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				gint _tmp3_;
				_tmp3_ = board[(x * board_length2) + y];
				_tmp1_ = _tmp3_ < ('z' + numworms);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				result = FALSE;
				return result;
			} else {
				gboolean _tmp4_ = FALSE;
				if (ox == x) {
					_tmp4_ = oy == y;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					result = FALSE;
					return result;
				}
				result = worm_ai_wander (board, board_length1, board_length2, numworms, x, y, dir, ox, oy);
				return result;
			}
		}
	}
}


void
worm_ai_move (Worm* self,
              gint* board,
              int board_length1,
              int board_length2,
              gint numworms,
              GeeLinkedList* worms)
{
	WormDirection opposite = 0;
	WormDirection _tmp0_;
	gboolean front = FALSE;
	Position _tmp1_ = {0};
	Position _tmp2_;
	gint _tmp3_;
	Position _tmp4_ = {0};
	Position _tmp5_;
	gint _tmp6_;
	WormDirection _tmp7_;
	Position _tmp8_ = {0};
	Position _tmp9_;
	gint _tmp10_;
	Position _tmp11_ = {0};
	Position _tmp12_;
	gint _tmp13_;
	gboolean left = FALSE;
	Position _tmp14_ = {0};
	Position _tmp15_;
	gint _tmp16_;
	Position _tmp17_ = {0};
	Position _tmp18_;
	gint _tmp19_;
	WormDirection _tmp20_;
	Position _tmp21_ = {0};
	Position _tmp22_;
	gint _tmp23_;
	Position _tmp24_ = {0};
	Position _tmp25_;
	gint _tmp26_;
	gboolean right = FALSE;
	Position _tmp27_ = {0};
	Position _tmp28_;
	gint _tmp29_;
	Position _tmp30_ = {0};
	Position _tmp31_;
	gint _tmp32_;
	WormDirection _tmp33_;
	Position _tmp34_ = {0};
	Position _tmp35_;
	gint _tmp36_;
	Position _tmp37_ = {0};
	Position _tmp38_;
	gint _tmp39_;
	gint dir = 0;
	gboolean _tmp40_;
	WormDirection old_dir = 0;
	WormDirection _tmp56_;
	gint best_yet = 0;
	gint best_dir = 0;
	gint this_len = 0;
	gint _tmp87_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worms != NULL);
	_tmp0_ = self->direction;
	opposite = ((_tmp0_ + 1) % 4) + 1;
	worm_get_head (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_.x;
	worm_get_head (self, &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_.y;
	_tmp7_ = self->direction;
	worm_get_head (self, &_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_.x;
	worm_get_head (self, &_tmp11_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_.y;
	front = worm_ai_wander (board, board_length1, board_length2, numworms, _tmp3_, _tmp6_, (gint) _tmp7_, _tmp10_, _tmp13_);
	worm_get_head (self, &_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_.x;
	worm_get_head (self, &_tmp17_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_.y;
	_tmp20_ = self->direction;
	worm_get_head (self, &_tmp21_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_.x;
	worm_get_head (self, &_tmp24_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_.y;
	left = worm_ai_wander (board, board_length1, board_length2, numworms, _tmp16_, _tmp19_, (gint) (_tmp20_ - 1), _tmp23_, _tmp26_);
	worm_get_head (self, &_tmp27_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_.x;
	worm_get_head (self, &_tmp30_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_.y;
	_tmp33_ = self->direction;
	worm_get_head (self, &_tmp34_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_.x;
	worm_get_head (self, &_tmp37_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _tmp38_.y;
	right = worm_ai_wander (board, board_length1, board_length2, numworms, _tmp29_, _tmp32_, (gint) (_tmp33_ + 1), _tmp36_, _tmp39_);
	_tmp40_ = front;
	if (!_tmp40_) {
		gboolean _tmp41_;
		_tmp41_ = left;
		if (_tmp41_) {
			WormDirection _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			_tmp42_ = self->direction;
			dir = (gint) (_tmp42_ - 1);
			_tmp43_ = dir;
			if (_tmp43_ < 1) {
				dir = 4;
			}
			_tmp44_ = dir;
			self->direction = (WormDirection) _tmp44_;
		} else {
			gboolean _tmp45_;
			_tmp45_ = right;
			if (_tmp45_) {
				WormDirection _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				_tmp46_ = self->direction;
				dir = (gint) (_tmp46_ + 1);
				_tmp47_ = dir;
				if (_tmp47_ > 4) {
					dir = 1;
				}
				_tmp48_ = dir;
				self->direction = (WormDirection) _tmp48_;
			} else {
				if (g_random_int_range ((gint32) 0, (gint32) 30) == ((gint32) 1)) {
					gint _tmp49_ = 0;
					WormDirection _tmp50_;
					gint _tmp51_;
					WormDirection _tmp52_;
					if (g_random_boolean ()) {
						_tmp49_ = 1;
					} else {
						_tmp49_ = -1;
					}
					_tmp50_ = self->direction;
					dir = (gint) (_tmp50_ + _tmp49_);
					_tmp51_ = dir;
					_tmp52_ = opposite;
					if (_tmp51_ != ((gint) _tmp52_)) {
						gint _tmp53_;
						gint _tmp54_;
						gint _tmp55_;
						_tmp53_ = dir;
						if (_tmp53_ > 4) {
							dir = 1;
						}
						_tmp54_ = dir;
						if (_tmp54_ < 1) {
							dir = 4;
						}
						_tmp55_ = dir;
						self->direction = (WormDirection) _tmp55_;
					}
				}
			}
		}
	}
	_tmp56_ = self->direction;
	old_dir = _tmp56_;
	best_yet = NIBBLES_GAME_CAPACITY * 2;
	best_dir = -1;
	{
		gboolean _tmp57_ = FALSE;
		dir = 1;
		_tmp57_ = TRUE;
		while (TRUE) {
			gint _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			WormDirection _tmp62_;
			gint _tmp65_;
			Position _tmp66_ = {0};
			Position _tmp67_;
			gint _tmp68_;
			Position _tmp69_ = {0};
			Position _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			gboolean _tmp76_ = FALSE;
			gint _tmp77_;
			WormDirection _tmp78_;
			gint _tmp81_;
			gint _tmp83_;
			gint _tmp84_;
			if (!_tmp57_) {
				gint _tmp58_;
				_tmp58_ = dir;
				dir = _tmp58_ + 1;
			}
			_tmp57_ = FALSE;
			_tmp59_ = dir;
			if (!(_tmp59_ <= 4)) {
				break;
			}
			_tmp60_ = dir;
			self->direction = (WormDirection) _tmp60_;
			_tmp61_ = dir;
			_tmp62_ = opposite;
			if (_tmp61_ == ((gint) _tmp62_)) {
				continue;
			}
			this_len = 0;
			if (!worm_can_move_to (self, board, board_length1, board_length2, numworms)) {
				gint _tmp63_;
				_tmp63_ = this_len;
				this_len = _tmp63_ + NIBBLES_GAME_CAPACITY;
			}
			if (worm_ai_too_close (self, worms, numworms)) {
				gint _tmp64_;
				_tmp64_ = this_len;
				this_len = _tmp64_ + 4;
			}
			_tmp65_ = this_len;
			worm_get_head (self, &_tmp66_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _tmp67_.x;
			worm_get_head (self, &_tmp69_);
			_tmp70_ = _tmp69_;
			_tmp71_ = _tmp70_.y;
			_tmp72_ = dir;
			_tmp73_ = worm_get_length (self);
			_tmp74_ = _tmp73_;
			_tmp75_ = self->change;
			this_len = _tmp65_ + worm_ai_deadend_after (board, board_length1, board_length2, worms, numworms, _tmp68_, _tmp71_, _tmp72_, _tmp74_ + _tmp75_);
			_tmp77_ = dir;
			_tmp78_ = old_dir;
			if (_tmp77_ == ((gint) _tmp78_)) {
				gint _tmp79_;
				_tmp79_ = this_len;
				_tmp76_ = _tmp79_ <= 0;
			} else {
				_tmp76_ = FALSE;
			}
			if (_tmp76_) {
				gint _tmp80_;
				_tmp80_ = this_len;
				this_len = _tmp80_ - 100;
			}
			_tmp81_ = this_len;
			if (_tmp81_ <= 0) {
				gint _tmp82_;
				_tmp82_ = this_len;
				this_len = _tmp82_ - g_random_int_range ((gint32) 0, (gint32) 100);
			}
			_tmp83_ = this_len;
			_tmp84_ = best_yet;
			if (_tmp83_ < _tmp84_) {
				gint _tmp85_;
				gint _tmp86_;
				_tmp85_ = this_len;
				best_yet = _tmp85_;
				_tmp86_ = dir;
				best_dir = _tmp86_;
			}
		}
	}
	_tmp87_ = best_dir;
	self->direction = (WormDirection) _tmp87_;
	{
		gboolean _tmp88_ = FALSE;
		dir = 1;
		_tmp88_ = TRUE;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			WormDirection _tmp92_;
			if (!_tmp88_) {
				gint _tmp89_;
				_tmp89_ = dir;
				dir = _tmp89_ + 1;
			}
			_tmp88_ = FALSE;
			_tmp90_ = dir;
			if (!(_tmp90_ <= 4)) {
				break;
			}
			_tmp91_ = dir;
			_tmp92_ = opposite;
			if (_tmp91_ == ((gint) _tmp92_)) {
				continue;
			}
			if (!worm_can_move_to (self, board, board_length1, board_length2, numworms)) {
				gint _tmp93_;
				_tmp93_ = dir;
				self->direction = (WormDirection) _tmp93_;
			} else {
				continue;
			}
		}
	}
}


void
worm_get_starting_position (Worm* self,
                            Position * result)
{
	Position _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_starting_position;
	*result = _tmp0_;
	return;
}


static void
worm_set_starting_position (Worm* self,
                            Position * value)
{
	Position old_value;
	g_return_if_fail (self != NULL);
	if (_position_equal (value, (worm_get_starting_position (self, &old_value), &old_value)) != TRUE) {
		Position _tmp0_;
		_tmp0_ = *value;
		self->priv->_starting_position = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_STARTING_POSITION_PROPERTY]);
	}
}


gint
worm_get_id (Worm* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void
worm_set_id (Worm* self,
             gint value)
{
	g_return_if_fail (self != NULL);
	if (worm_get_id (self) != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_ID_PROPERTY]);
	}
}


gboolean
worm_get_is_materialized (Worm* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_materialized;
	result = _tmp0_;
	return result;
}


static void
worm_set_is_materialized (Worm* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	if (worm_get_is_materialized (self) != value) {
		self->priv->_is_materialized = value;
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_IS_MATERIALIZED_PROPERTY]);
	}
}


gint
worm_get_lives (Worm* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_lives;
	result = _tmp0_;
	return result;
}


void
worm_set_lives (Worm* self,
                gint value)
{
	g_return_if_fail (self != NULL);
	if (worm_get_lives (self) != value) {
		self->priv->_lives = value;
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LIVES_PROPERTY]);
	}
}


gint
worm_get_score (Worm* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_score;
	result = _tmp0_;
	return result;
}


void
worm_set_score (Worm* self,
                gint value)
{
	g_return_if_fail (self != NULL);
	if (worm_get_score (self) != value) {
		self->priv->_score = value;
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_SCORE_PROPERTY]);
	}
}


gint
worm_get_length (Worm* self)
{
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void
worm_set_length (Worm* self,
                 gint value)
{
	g_return_if_fail (self != NULL);
	g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LENGTH_PROPERTY]);
}


void
worm_get_head (Worm* self,
               Position * result)
{
	Position head = {0};
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	Position* _tmp2_;
	Position _tmp3_;
	Position _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list;
	_tmp1_ = gee_linked_list_first (_tmp0_);
	_tmp2_ = (Position*) _tmp1_;
	_tmp3_ = *_tmp2_;
	_position_free0 (_tmp2_);
	head = _tmp3_;
	_tmp4_ = head;
	*result = _tmp4_;
	return;
}


static void
worm_set_head (Worm* self,
               Position * value)
{
	GeeLinkedList* _tmp0_;
	Position _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list;
	_tmp1_ = *value;
	gee_abstract_list_set ((GeeAbstractList*) _tmp0_, 0, &_tmp1_);
	g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_HEAD_PROPERTY]);
}


GeeLinkedList*
worm_get_list (Worm* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list;
	result = _tmp0_;
	return result;
}


static void
worm_set_list (Worm* self,
               GeeLinkedList* value)
{
	g_return_if_fail (self != NULL);
	if (worm_get_list (self) != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list);
		self->priv->_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LIST_PROPERTY]);
	}
}


static void
worm_class_init (WormClass * klass)
{
	guint* _tmp0_;
	worm_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (WormPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_worm_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_worm_set_property;
	G_OBJECT_CLASS (klass)->finalize = worm_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_STARTING_POSITION_PROPERTY, worm_properties[WORM_STARTING_POSITION_PROPERTY] = g_param_spec_boxed ("starting-position", "starting-position", "starting-position", TYPE_POSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_ID_PROPERTY, worm_properties[WORM_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_IS_MATERIALIZED_PROPERTY, worm_properties[WORM_IS_MATERIALIZED_PROPERTY] = g_param_spec_boolean ("is-materialized", "is-materialized", "is-materialized", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIVES_PROPERTY, worm_properties[WORM_LIVES_PROPERTY] = g_param_spec_int ("lives", "lives", "lives", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_SCORE_PROPERTY, worm_properties[WORM_SCORE_PROPERTY] = g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LENGTH_PROPERTY, worm_properties[WORM_LENGTH_PROPERTY] = g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_HEAD_PROPERTY, worm_properties[WORM_HEAD_PROPERTY] = g_param_spec_boxed ("head", "head", "head", TYPE_POSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIST_PROPERTY, worm_properties[WORM_LIST_PROPERTY] = g_param_spec_object ("list", "list", "list", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	worm_signals[WORM_ADDED_SIGNAL] = g_signal_new ("added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_FINISH_ADDED_SIGNAL] = g_signal_new ("finish-added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_RESCALED_SIGNAL] = g_signal_new ("rescaled", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	worm_signals[WORM_DIED_SIGNAL] = g_signal_new ("died", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_TAIL_REDUCED_SIGNAL] = g_signal_new ("tail-reduced", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	worm_signals[WORM_REVERSED_SIGNAL] = g_signal_new ("reversed", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_BONUS_FOUND_SIGNAL] = g_signal_new ("bonus-found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_WARP_FOUND_SIGNAL] = g_signal_new ("warp-found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_new0 (guint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
	worm_deadend_board = _tmp0_;
	worm_deadend_board_length1 = NIBBLES_GAME_WIDTH;
	worm_deadend_board_length2 = NIBBLES_GAME_HEIGHT;
}


static void
worm_instance_init (Worm * self)
{
	self->priv = WORM_GET_PRIVATE (self);
	self->keypress = FALSE;
	self->is_stopped = FALSE;
	self->priv->_is_materialized = TRUE;
}


static void
worm_finalize (GObject * obj)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORM, Worm);
	_g_object_unref0 (self->priv->key_queue);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (worm_parent_class)->finalize (obj);
}


GType
worm_get_type (void)
{
	static volatile gsize worm_type_id__volatile = 0;
	if (g_once_init_enter (&worm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Worm), 0, (GInstanceInitFunc) worm_instance_init, NULL };
		GType worm_type_id;
		worm_type_id = g_type_register_static (G_TYPE_OBJECT, "Worm", &g_define_type_info, 0);
		g_once_init_leave (&worm_type_id__volatile, worm_type_id);
	}
	return worm_type_id__volatile;
}


static void
_vala_worm_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
	switch (property_id) {
		case WORM_STARTING_POSITION_PROPERTY:
		{
			Position boxed;
			worm_get_starting_position (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case WORM_ID_PROPERTY:
		g_value_set_int (value, worm_get_id (self));
		break;
		case WORM_IS_MATERIALIZED_PROPERTY:
		g_value_set_boolean (value, worm_get_is_materialized (self));
		break;
		case WORM_LIVES_PROPERTY:
		g_value_set_int (value, worm_get_lives (self));
		break;
		case WORM_SCORE_PROPERTY:
		g_value_set_int (value, worm_get_score (self));
		break;
		case WORM_LENGTH_PROPERTY:
		g_value_set_int (value, worm_get_length (self));
		break;
		case WORM_HEAD_PROPERTY:
		{
			Position boxed;
			worm_get_head (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case WORM_LIST_PROPERTY:
		g_value_set_object (value, worm_get_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_worm_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
	switch (property_id) {
		case WORM_STARTING_POSITION_PROPERTY:
		worm_set_starting_position (self, g_value_get_boxed (value));
		break;
		case WORM_ID_PROPERTY:
		worm_set_id (self, g_value_get_int (value));
		break;
		case WORM_IS_MATERIALIZED_PROPERTY:
		worm_set_is_materialized (self, g_value_get_boolean (value));
		break;
		case WORM_LIVES_PROPERTY:
		worm_set_lives (self, g_value_get_int (value));
		break;
		case WORM_SCORE_PROPERTY:
		worm_set_score (self, g_value_get_int (value));
		break;
		case WORM_LENGTH_PROPERTY:
		worm_set_length (self, g_value_get_int (value));
		break;
		case WORM_HEAD_PROPERTY:
		worm_set_head (self, g_value_get_boxed (value));
		break;
		case WORM_LIST_PROPERTY:
		worm_set_list (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



