package main

import (
	"crypto/hmac"
	"crypto/md5"
	"crypto/sha1"
	"encoding/base64"
	"fmt"
	"strings"
	"time"
)

/**
Authorization: UPYUN <Operator>:<Signature>
<Signature> = Base64 (HMAC-SHA1 (<Password>,
<Method>&
<URI>&
<Date>&
<Content-MD5>
))
**/

// ignore content md5
func doSignature(method, uri, date, passwd, contentMd5 string) string {
	pmd5 := md5Str(passwd)
	var list []string
	for _, v := range []string{method, uri, date, contentMd5} {
		if len(v) == 0 {
			continue
		}
		list = append(list, v)
	}
	tmp := strings.Join(list, "&")
	enc := hmac.New(sha1.New, []byte(pmd5))
	enc.Write([]byte(tmp))

	return base64.StdEncoding.EncodeToString(enc.Sum(nil))
}

func makeRFC1123Date() string {
	utc := time.Now().UTC().Format(time.RFC1123)
	return strings.Replace(utc, "UTC", "GMT", -1)
}

func md5Str(data string) string {
	return fmt.Sprintf("%x", md5.Sum([]byte(data)))
}

func base64Str(data []byte) string {
	return base64.StdEncoding.EncodeToString(data)
}
