package storage

import (
	"encoding/json"
	"net/http"

	"github.com/pkg/errors"
)

// 创建新版本
func (s *Storage) NewVersion() (string, error) {
	req, err := http.NewRequest("GET", SyncServerAPI()+"/timeVersion", nil)
	if err != nil {
		return "", errors.Wrap(err, "time version")
	}
	req.Header.Set(AuthToken, s.token)
	resp, err := http.DefaultClient.Do(req)
	if err != nil {
		return "", errors.Wrap(err, "http do")
	}
	defer resp.Body.Close()
	var result timeVersionResult
	err = json.NewDecoder(resp.Body).Decode(&result)
	if err != nil {
		return "", errors.Wrap(err, "decode result")
	}
	return result.Time, nil
}

type timeVersionResult struct {
	Time string `json:"timeVersion"`
}
