# 深度商店“赞赏”功能说明

## 为什么需要“赞赏”

一直以来，在开源社区中，任何人都可以无偿的获取源码、复制和分发软件。在这个模式下，很多开发者用自己的热情、能力和业余时间，为 Linux 的用户提供了大量优秀的软件。然而也有很多优秀的开源免费软件，因为作者时间或者运行社区的经济压力停止了更新。
因此，我们希望在尊重开源社区开发者的劳动成果和规则的前提下，通过用户自己决定的“赞赏”行为，对这些作者或者社区进行帮助。希望这些“赞赏”的收入，能够对开源社区作者有所鼓励或者支持必要的运营费用。
同时，还有很多优秀商业软件的 Linux 版本不为人所知，因此我们根据用户的推荐，还收录了很多优秀且免费（或者试用）的非开源软件。对于这些软件来说，我们希望通过提供的“赞赏”收入，让应用软件厂商认可 Linux 社区和用户对优秀软件的旺盛需求。
具体来说，“赞赏”功能的目的如下：

1.  让开发者和打包者通过深度商店平台获取用户的认可和鼓励；
1.  获取资金来支持高水准的应用软件服务器、带宽等各种实际需求；
1.  鼓励开源社区和商业开发者积极的开发、迭代和维护应用；
1.  提供一个开源软件和 Linux 商业分发的平台，吸引更多开发者参与社区生态的建设。

在深度商店中无论是开源还是免费闭源软件，都将默认开通该软件的赞赏通道，并为其提供上架后获得赞赏分成、提现申请、作者认领等功能。

## 什么是“赞赏”

为感谢社区开发者的积极贡献，让更多的开发者获得用户直接的认同，深度商店开通的应用“赞赏”功能，希望能为个人开发者或 Linux 软件开发商提供一个获得合理回报的机制。
注意：赞赏并不是购买软件，深度商店中的很多软件都是免费使用而无需购买。赞赏也不是强制的行为，你完全可以免费下载和使用这些软件。提供赞赏仅是因为你对该软件的认可，自愿向作者和软件打包者支付的小额奖金。

## “赞赏”收入的分配

每个软件的赞赏收入，当前按照开发者、打包者、运营者三方，6:2:2 的比例进行分配。（注意：分成原则后续可能随着官方运营策略有所变化）
我们将主动联系各软件原始开发者或者组织，以便其主动认领收录的软件，并提供官方的安装包。如果开发者和打包者为同一作者，则分成中的 80%(60%+20%)均归其所有，运营方获得 20%。
如果根据法律要求涉及到个人所得税问题，在中国境内，深度公司可代扣代缴该所得税；在中国境外，需作者自行申报纳税。

## “赞赏”如何提现

开发者、打包者需要注册 Deepin ID 后，再登录个人后台：https://dstore-metadata.deepin.cn ，查看参与开发、打包的应用列表。
在后台中可以查看对应项目的赞赏金额汇总和明细，当总金额达到人民币 100 元时（或折算达到$20 美元），可以申请提现，官方审核后将在 5 个工作日内进行处理。作者/打包者可随时跟踪自己的申请状态。

## 无人认领的“赞赏”如何使用

如果某些软件开发者一直无法联系或没有进行认领，我们将在每年 12 月进行汇总并提取这部分“赞赏”费用，将未认领开发者的赞赏金额全部捐助到其他需支持的重要开源社区或组织。（具体捐助对象，金额信息将会在每年 11 月进行公开发布并征求社区建议）

## 如何申请成为作者

希望发布自己的软件成为作者，或你是商店中已经上架软件的作者，需要认领作者权益。当前我们没有开放自助申请通道，请各位作者联系 appstore@deepin.com。
对作者的要求：该应用的原始个人开发者和开发者团队（负责人），其作品符合深度商店的收录原则或已经被收录，参见：https://www.deepin.org/deliver-applications.

## 如何成为打包者

打包者需要按照深度商店软件要求，提供深度商店要求的软件包和元数据信息。当前我们没有开放第三方自动打包通道，希望成为打包者的朋友在后台提交应用基本信息后，请发送邮件到 appstore@deepin.com，内容包括：申请者 id(deepinid) 、Github id、项目地址、项目介绍、项目名称、是否为原作者、联系邮箱。会有官方人员与您联系。第三方打包通道正式开通前会另行通知。
（注意：打包者需要为自己的项目取一个具有唯一标示的名称。例如，dde 插件类：dde-\*\*\*-plugin；应用类：\*\*\*-music，\*\*\*-movie；图标主题：\*\*\*-icon-theme；gtk 主题：gtk-theme-\*\*\*）
成为某个软件的打包者之后，如未来原软件进行了更新，打包者必须在一周内及时跟进原始软件的更新。如出现三次延迟更新，或单次延迟更新超过两周，将取消该打包者在该软件包上的权限，后续的赞赏也不再计入该打包者名下。
如果该软件包原始作者提供了符合要求的打包软件，或已经有合格的打包者，我们将不接受该软件新的打包者申请。由于我们会优先收录 flatpak 格式的软件，因此当该软件包没有 flatpak 包格式，而新打包者能够提供以 flatpak 方式进行打包的软件时，我们会接受该软件新打包者的申请。

## 注意事项

- 收录到深度商店的应用将默认开通“赞赏”功能，如原始开发者/开发公司认为无需此功能，可通过 appstore@deepin.com 联系我们取消“赞赏”功能。
- 如果原始开发商/开发者，在其作品约定的版权/著作权的要求下，不允许深度商店进行分发，也可通过 appstore@deepin.com  联系我们撤下该应用。
