#pragma once

#ifndef __MONITOR_THREAD_H__
#define __MONITOR_THREAD_H__


#include <QThread>
#include <QMap>

class MonitorThread: public QThread
{
    Q_OBJECT

public:
    MonitorThread(int iPurpose=1);
    virtual ~MonitorThread();

    virtual void run() override;
    void userId(uid_t uid);
    uid_t userId();
    void purpose(int iPurpose);
    int purpose();
    void secondSpan(int iSpan);
    int secondSpan();
    void updateWorkSpaceImagePath();

private:
    QString m_userImagePath;
    QString m_lastSettingPath;
    bool m_bRunning = false;
    int m_iSecondSpan = 5;
    int m_iPurpose = 1; //1 是锁屏， 2是启动器， 3-16 是工作区
    uid_t m_iUserId = INT_MAX;
    const QString m_blurPath = ".cache/dde-preload/blur-images";
};


#endif // __MONITOR_THREAD_H__