/*
 * Copyright (C) 2019 ~ 2020 Deepin Technology Co., Ltd.
 *
 * Author:     Kevin.Guan <allmemory@vip.qq.com>
 *             caowei <zhtqs8@163.com>
 *
 * Maintainer: Kevin.Guan <allmemory@vip.qq.com>
 *             caowei <zhtqs8@163.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CPRELOAD_H
#define CPRELOAD_H


#include <unistd.h>
#include <pwd.h>
#include <QObject>
#include <QMap>
#include <QHash>
#include <QList>
#include <QSharedPointer>
#include <QDBusAbstractAdaptor>

#define DDE_PRELOAD_NAME "com.deepin.dde.preload"
#define DDE_PRELOAD_PATH "/com/deepin/dde/preload"

class ImageKey;

/**
 * @brief 图片预加载类型
 *
 */
class cPreLoad : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", DDE_PRELOAD_NAME)

public:
    /**
     * @brief 构造函数
     *
     * @param parent
     */
    explicit cPreLoad(QObject *parent = nullptr);
    /**
     * @brief 析构函数，清理共享内存。
     *
     */
    virtual ~cPreLoad();

signals:
    /**
     * @brief 资源创建成功
     *
     * @param uid Linux用户ID
     * @param purpose 用途，比如锁屏或者工作空间
     */
    void createSuccessful(int uid, int purpose, const QString &key);
    /**
     * @brief 资源释放成功
     *
     * @param uid Linux用户ID
     * @param purpose 用途，比如锁屏或者工作空间
     */
    void releaseSuccessful(int uid, int purpose, const QString &key);

public slots:

    /**
     * @brief 请求资源类型 0代表锁屏壁纸 1-16代表工作区路径 返回为共享内存的Key
     *
     *
     * @param uid linux用户id
     * @param purpose 图片的用途：锁屏为1,启动器2,工作区为3-19
     * @return QString 共享内存key
     */
    QString requestSource(int uid, int purpose);
    void exit();

private:
    void init();
    bool isResourceExist(QString imagePath);
    bool isResourceExist(QString imagePath, uint32_t uid);
    QString getResourcePath(int purpose);
    QString getResourcePath(int purpose, uint32_t uid);
    QSharedPointer<ImageKey> getResource(int purpose, uint32_t uid);
    QSharedPointer<ImageKey> createResource(int purpose, uint32_t uid);
    QString getImagePath(int purpose, uint32_t uid);
    void updaetImagePath(QSharedPointer<ImageKey> &imageKey, uint32_t uid);
    void readImage(QSharedPointer<ImageKey> &imageKey, uint32_t uid);
    QByteArray blurImage(QSharedPointer<ImageKey> &imageKey);

private:
    //用户ID与图片路径的数据结构
    QHash<uint32_t, QSharedPointer<QList<QSharedPointer<ImageKey>>>> m_resources;
    const QString m_blurPath = ".cache/dde-preload/blur-images";
};

#endif // CPRELOAD_H
