// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef CONNECTIVITYPROCESSER_H
#define CONNECTIVITYPROCESSER_H

#include "networkconst.h"

#include <QObject>

class QTimer;
class QThread;

namespace Dtk {
namespace Core {
class DConfig;
}
}

namespace dde {

namespace network {

class NetworkProcesser;
class ConnectivityChecker;
class NetworkDeviceBase;
class AccessPoints;

class ConnectivityProcesser : public QObject
{
    Q_OBJECT

public:
    explicit ConnectivityProcesser(NetworkProcesser *networkProcesser, QObject *parent = nullptr);
    ~ConnectivityProcesser();
    Connectivity connectivity() const;

signals:
    void connectivityChanged(const Connectivity &) const;

private:
    void createConnectivityChecker();
    void initConnectivityChecker(int interval);
    void initDeviceConnect(const QList<NetworkDeviceBase *> &devices);
    void updateAccessPointConnect(const QList<AccessPoints *> &accessPoints);
    void stopChecker();

private slots:
    void onCheckStatusChanged(bool isConnected);
    void onConnectivityChanged(const Connectivity &connectivity);
    void onConfigChanged(const QString &key);

private:
    NetworkProcesser *m_networkProcesser;
    ConnectivityChecker *m_connectivityChecker;
    Connectivity m_connectivity;
    QThread *m_checkThread;
    QTimer *m_checkTimer;
    QTimer *m_timer;
    Dtk::Core::DConfig *m_dConfig;
    QMetaObject::Connection m_nmConnectivityConnection;
    QList<QMetaObject::Connection> m_checkerConnection;
};

}
}

#endif // CONNECTIVITYPROCESSER_H
