<a name="internal_dicts"></a>

# Встроенные словари

ClickHouse содержит встроенную возможность работы с геобазой.

Это позволяет:

-   для идентификатора региона получить его имя на нужном языке;
-   по идентификатору региона получить идентификатор города, области, федерального округа, страны, континента;
-   проверить, что один регион входит в другой;
-   получить цепочку родительских регионов.

Все функции поддерживают "транслокальность", то есть возможность использовать одновременно разные точки зрения на принадлежность регионов. Подробнее смотрите в разделе "Функции для работы со словарями Яндекс.Метрики".

В пакете по умолчанию, встроенные словари выключены.
Для включения, раскомментируйте параметры `path_to_regions_hierarchy_file` и `path_to_regions_names_files` в конфигурационном файле сервера.

Геобаза загружается из текстовых файлов.

Положите файлы `regions_hierarchy*.txt` в директорию `path_to_regions_hierarchy_file`. Этот конфигурационный параметр должен содержать путь к файлу `regions_hierarchy.txt` (иерархия регионов по умолчанию), а другие файлы (`regions_hierarchy_ua.txt`) должны находиться рядом в той же директории.

Положите файлы `regions_names_*.txt` в директорию `path_to_regions_names_files`.

Также вы можете создать эти файлы самостоятельно. Формат файлов такой:

`regions_hierarchy*.txt`: TabSeparated (без заголовка), столбцы:

-   идентификатор региона (`UInt32`);
-   идентификатор родительского региона (`UInt32`);
-   тип региона (`UInt8`): 1 - континент, 3 - страна, 4 - федеральный округ, 5 - область, 6 - город; остальные типы не имеют значения;
-   население (`UInt32`) - не обязательный столбец.

`regions_names_*.txt`: TabSeparated (без заголовка), столбцы:

-   идентификатор региона (`UInt32`);
-   имя региона (`String`) - не может содержать табы или переводы строк, даже экранированные.

Для хранения в оперативке используется плоский массив. Поэтому, идентификаторы не должны быть больше миллиона.

Словари могут обновляться без перезапуска сервера. Но набор доступных словарей не обновляется.
Для обновления проверяется время модификации файлов; если файл изменился, то словарь будет обновлён.
Периодичность проверки настраивается конфигурационным параметром `builtin_dictionaries_reload_interval`.
Обновление словарей (кроме загрузки при первом использовании) не блокирует запросы - во время обновления запросы используют старую версию словарей. Если при обновлении возникнет ошибка, то ошибка пишется в лог сервера, а запросы продолжат использовать старую версию словарей.

Рекомендуется периодически обновлять словари с геобазой. При обновлении, генерируйте новые файлы, записывая их в отдельное место, а только когда всё готово - переименовывайте в файлы, которые использует сервер.

Также имеются функции для работы с идентификаторами операционных систем и поисковых систем Яндекс.Метрики, пользоваться которыми не нужно.

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/dicts/internal_dicts/) <!--hide-->
