# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.2 on Tue Jun  8 14:45:47 2004
# Hands modified! Do not use wxGlade again.

import wx
import BIB

class settings(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MyDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.panel_2 = wx.Panel(self, -1)	# contains Pipe settings
        self.panel_1 = wx.Panel(self, -1)	# contains TCP/IP settings
        self.radio_box_1 = wx.RadioBox(self, -1, _("Connection type"), choices=[_("TCP/IP"), _("Pipe")], majorDimension=2, style=wx.RA_SPECIFY_COLS)
        self.label_1 = wx.StaticText(self.panel_1, -1, _("Port"))
        self.spin_ctrl_1 = wx.SpinCtrl(self.panel_1, -1, "", min=1, max=50000)
        self.label_2 = wx.StaticText(self.panel_2, -1, _("Pipe name"))
        self.text_ctrl_1 = wx.TextCtrl(self.panel_2, -1, "")
        self.button_1 = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
        self.button_2 = wx.Button(self, wx.ID_OK, _("OK"))
        #
        self.__set_properties()
        self.__do_layout()
        self.__set_values()     # set the values from config
        self.onConnType(None)   # hide/show correct settings
        self.__set_evt()
        self.CenterOnParent()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: MyDialog.__set_properties
        self.SetTitle(_("OpenOffice connection settings"))
        self.radio_box_1.SetSelection(0)
        self.button_2.SetDefault()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MyDialog.__do_layout
        self.sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        self.sizer_1.Add(self.radio_box_1, 0, 0, 0)
        sizer_2.Add(self.label_1, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_2.Add(self.spin_ctrl_1, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        self.panel_1.SetAutoLayout(1)
        self.panel_1.SetSizer(sizer_2)
        sizer_2.Fit(self.panel_1)
        sizer_2.SetSizeHints(self.panel_1)
        self.sizer_1.Add(self.panel_1, 0, wx.EXPAND|wx.ALL, 5)
        sizer_3.Add(self.label_2, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_3.Add(self.text_ctrl_1, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        self.panel_2.SetAutoLayout(1)
        self.panel_2.SetSizer(sizer_3)
        sizer_3.Fit(self.panel_2)
        sizer_3.SetSizeHints(self.panel_2)
        self.sizer_1.Add(self.panel_2, 0, wx.EXPAND|wx.ALL, 5)
        self.sizer_1.Show(self.panel_2,False)
        sizer_4.Add((10, 10), 1, 0, 0)
        sizer_4.Add(self.button_1, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_4.Add((10, 10), 0, 0, 0)
        sizer_4.Add(self.button_2, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_4.Add((10, 10), 1, 0, 0)
        self.sizer_1.Add(sizer_4, 0, wx.EXPAND, 0)
        self.SetAutoLayout(1)
        self.SetSizer(self.sizer_1)
        self.sizer_1.Fit(self)
        self.sizer_1.SetSizeHints(self)
        self.Layout()
        # end wxGlade

    def __set_evt(self):
        wx.EVT_BUTTON(self,wx.ID_OK,self.onOK)
        wx.EVT_RADIOBOX(self,self.radio_box_1.GetId(),self.onConnType)

    def __set_values(self):
        self.radio_box_1.SetSelection(BIB.OO_CON_TYPE)
        self.spin_ctrl_1.SetValue(BIB.OO_PORT)
        self.text_ctrl_1.SetValue(BIB.OO_PIPE)

    def onConnType(self,evt):
        self.sizer_1.Show(self.panel_1,not self.radio_box_1.GetSelection())
        self.sizer_1.Show(self.panel_2,self.radio_box_1.GetSelection())
        self.Layout()
        #self.panel_1.Enable(not self.radio_box_1.GetSelection())
        #self.panel_2.Enable(self.radio_box_1.GetSelection())


    def onOK(self,event):
        BIB.OO_CON_TYPE = self.radio_box_1.GetSelection()
        BIB.OO_PORT = self.spin_ctrl_1.GetValue()
        BIB.OO_PIPE = self.text_ctrl_1.GetValue()
        self.Close()

# end of class settings


