/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:39:34 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.BlastM8ComparisonData;
import uk.ac.sanger.artemis.MSPcrunchComparisonData;
import uk.ac.sanger.artemis.MUMmerComparisonData;
import uk.ac.sanger.artemis.MegaBlastComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class SimpleComparisonData_ESTest extends SimpleComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(693, 898, 898, 283, 1996, 1996);
      assertEquals(1996, alignMatch0.getScore());
      assertEquals(205, alignMatch0.getLength());
      assertTrue(alignMatch0.isRevMatch());
      assertEquals(1996, alignMatch0.getPercentID());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(555, (-3821), (-3821), 511, 49, 49);
      assertEquals(4376, alignMatch0.getLength());
      assertTrue(alignMatch0.isRevMatch());
      assertEquals(49, alignMatch0.getPercentID());
      assertEquals(49, alignMatch0.getScore());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(0, 962, 501, 962, (-152), (-584));
      assertEquals((-584), alignMatch0.getPercentID());
      assertEquals((-152), alignMatch0.getScore());
      assertFalse(alignMatch0.isRevMatch());
      assertEquals(962, alignMatch0.getLength());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(648, 648, 648, 648, 0, 0);
      assertEquals(0, alignMatch0.getPercentID());
      assertEquals(0, alignMatch0.getLength());
      assertFalse(alignMatch0.isRevMatch());
      assertEquals(0, alignMatch0.getScore());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      SimpleComparisonData simpleComparisonData0 = mSPcrunchComparisonData0.getNewSimpleComparisonData();
      assertFalse(simpleComparisonData0.equals((Object)mSPcrunchComparisonData0));
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      try { 
        mSPcrunchComparisonData0.makeMatchFromString("match goes off end of query sequence: ");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading MSPcrunch data: not enough fields in this line: match goes off end of query sequence: 
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData();
      // Undeclared exception!
      try { 
        megaBlastComparisonData0.getMinimumScore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData();
      // Undeclared exception!
      try { 
        mUMmerComparisonData0.getMaximumScore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      AlignMatch[] alignMatchArray0 = new AlignMatch[0];
      mSPcrunchComparisonData0.setMatches(alignMatchArray0);
      int int0 = mSPcrunchComparisonData0.getMinimumScore();
      assertEquals(999999999, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(0, (-1876), 0, 2728, 2728, 256);
      assertTrue(alignMatch0.isRevMatch());
      assertEquals(2728, alignMatch0.getScore());
      assertEquals(1876, alignMatch0.getLength());
      assertEquals(256, alignMatch0.getPercentID());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      AlignMatch[] alignMatchArray0 = new AlignMatch[1];
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(934, 934, 934, (-171), 116, (-2133));
      alignMatchArray0[0] = alignMatch0;
      mSPcrunchComparisonData0.setMatches(alignMatchArray0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      AlignMatch[] alignMatchArray0 = new AlignMatch[1];
      // Undeclared exception!
      try { 
        mSPcrunchComparisonData0.setMatches(alignMatchArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = 'm';
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      PushbackReader pushbackReader0 = new PushbackReader(charArrayReader0, 173);
      BufferedReader bufferedReader0 = new BufferedReader(pushbackReader0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(bufferedReader0);
      MUMmerComparisonData mUMmerComparisonData0 = null;
      try {
        mUMmerComparisonData0 = new MUMmerComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // unable to understand this line: m\u0000
         //
         verifyException("uk.ac.sanger.artemis.MUMmerComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      char[] charArray0 = new char[2];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      PushbackReader pushbackReader0 = new PushbackReader(charArrayReader0, 173);
      BufferedReader bufferedReader0 = new BufferedReader(pushbackReader0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(bufferedReader0);
      MUMmerComparisonData mUMmerComparisonData0 = new MUMmerComparisonData(linePushBackReader0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      BlastM8ComparisonData blastM8ComparisonData0 = new BlastM8ComparisonData();
      AlignMatch[] alignMatchArray0 = blastM8ComparisonData0.getMatches();
      assertNull(alignMatchArray0);
  }
}
